/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.wildfly.event.logger.EventLogger;
import org.wildfly.extension.undertow.AccessLogAttribute;

class EventLoggerHttpHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ExchangeCompletionListener exchangeCompletionListener = new AccessLogCompletionListener();
    private final Predicate predicate;
    private final Collection<AccessLogAttribute> attributes;
    private final EventLogger eventLogger;

    EventLoggerHttpHandler(HttpHandler next, Predicate predicate, Collection<AccessLogAttribute> attributes, EventLogger eventLogger) {
        this.next = next;
        this.predicate = predicate;
        this.attributes = attributes;
        this.eventLogger = eventLogger;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    private class AccessLogCompletionListener
    implements ExchangeCompletionListener {
        private AccessLogCompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                if (EventLoggerHttpHandler.this.predicate == null || EventLoggerHttpHandler.this.predicate.resolve(exchange)) {
                    LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
                    for (AccessLogAttribute attribute : EventLoggerHttpHandler.this.attributes) {
                        data.put(attribute.getKey(), attribute.resolveAttribute(exchange));
                    }
                    EventLoggerHttpHandler.this.eventLogger.log(data);
                }
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

