/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntrySizeCalculator;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.InternalDataContainerAdapter;
import org.infinispan.eviction.EvictionType;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.marshall.core.WrappedByteArraySizeCalculator;

@ThreadSafe
public class DefaultDataContainer<K, V>
extends AbstractInternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<K, InternalCacheEntry<K, V>> entries;
    private final Cache<K, InternalCacheEntry<K, V>> evictionCache;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = CollectionFactory.makeConcurrentParallelMap((int)128, (int)concurrencyLevel);
        this.evictionCache = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EvictionType thresholdPolicy) {
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        Caffeine caffeine = DefaultDataContainer.caffeineBuilder();
        switch (thresholdPolicy) {
            case MEMORY: {
                CacheEntrySizeCalculator calc = new CacheEntrySizeCalculator(new WrappedByteArraySizeCalculator((EntrySizeCalculator<?, ?>)new PrimitiveEntrySizeCalculator()));
                caffeine.weigher((k, v) -> (int)calc.calculateSize(k, v)).maximumWeight(thresholdSize);
                break;
            }
            case COUNT: {
                caffeine.maximumSize(thresholdSize);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Policy not supported: " + (Object)((Object)thresholdPolicy));
            }
        }
        this.evictionCache = DefaultDataContainer.applyListener(caffeine, evictionListener, null).build();
        this.entries = this.evictionCache.asMap();
    }

    protected DefaultDataContainer(int concurrencyLevel, long thresholdSize, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        this(thresholdSize, (EntrySizeCalculator<? super K, InternalCacheEntry<? super K, V>>)new CacheEntrySizeCalculator<K, V>(sizeCalculator));
    }

    protected DefaultDataContainer(long thresholdSize, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> sizeCalculator) {
        AbstractInternalDataContainer.DefaultEvictionListener evictionListener = new AbstractInternalDataContainer.DefaultEvictionListener();
        this.evictionCache = DefaultDataContainer.applyListener(Caffeine.newBuilder().weigher((k, v) -> (int)sizeCalculator.calculateSize(k, v)).maximumWeight(thresholdSize), evictionListener, null).build();
        this.entries = this.evictionCache.asMap();
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EvictionType thresholdPolicy) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, thresholdPolicy);
    }

    public static <K, V> DefaultDataContainer<K, V> boundedDataContainer(int concurrencyLevel, long maxEntries, EntrySizeCalculator<? super K, ? super V> sizeCalculator) {
        return new DefaultDataContainer<K, V>(concurrencyLevel, maxEntries, sizeCalculator);
    }

    public static <K, V> DefaultDataContainer<K, V> unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer<K, V>(concurrencyLevel);
    }

    @Override
    protected ConcurrentMap<K, InternalCacheEntry<K, V>> getMapForSegment(int segment) {
        return this.entries;
    }

    @Override
    protected int getSegmentForKey(Object key) {
        return -1;
    }

    private Policy.Eviction<K, InternalCacheEntry<K, V>> eviction() {
        Optional eviction;
        if (this.evictionCache != null && (eviction = this.evictionCache.policy().eviction()).isPresent()) {
            return (Policy.Eviction)eviction.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long capacity() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.getMaximum();
    }

    @Override
    public void resize(long newSize) {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        evict.setMaximum(newSize);
    }

    @Override
    public int sizeIncludingExpired() {
        return this.entries.size();
    }

    @Override
    public void clear(IntSet segments) {
        Iterator<InternalCacheEntry<K, V>> iter = this.iteratorIncludingExpired(segments);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public void clear() {
        log.tracef("Clearing data container", new Object[0]);
        this.entries.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator(this.entries.values().iterator());
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iterator(IntSet segments) {
        return new FilterIterator(this.iterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliterator(IntSet segments) {
        return new FilterSpliterator(this.spliterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired() {
        return this.entries.values().spliterator();
    }

    @Override
    public Spliterator<InternalCacheEntry<K, V>> spliteratorIncludingExpired(IntSet segments) {
        return new FilterSpliterator(this.spliteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired() {
        return this.entries.values().iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<K, V>> iteratorIncludingExpired(IntSet segments) {
        return new FilterIterator(this.iteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public void forEachIncludingExpired(ObjIntConsumer<? super InternalCacheEntry<K, V>> action) {
        this.iteratorIncludingExpired().forEachRemaining(ice -> action.accept((InternalCacheEntry<K, V>)ice, this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public long evictionSize() {
        Policy.Eviction<K, InternalCacheEntry<K, V>> evict = this.eviction();
        return evict.weightedSize().orElse(this.entries.size());
    }

    @Override
    public void addSegments(IntSet segments) {
    }

    @Override
    public void removeSegments(IntSet segments) {
        InternalDataContainerAdapter.removeSegmentEntries(this, segments, this.listeners, this.keyPartitioner);
    }

    @Override
    public void executeTask(KeyFilter<? super K> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        long now = this.timeService.wallClockTime();
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept(key) && !value.isExpired(now)) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void executeTask(KeyValueFilter<? super K, ? super V> filter, BiConsumer<? super K, InternalCacheEntry<K, V>> action) throws InterruptedException {
        if (filter == null) {
            throw new IllegalArgumentException("No filter specified");
        }
        if (action == null) {
            throw new IllegalArgumentException("No action specified");
        }
        long now = this.timeService.wallClockTime();
        this.entries.forEach((? super K key, ? super V value) -> {
            if (filter.accept((Object)key, (Object)value.getValue(), value.getMetadata()) && !value.isExpired(now)) {
                action.accept((Object)key, (InternalCacheEntry)value);
            }
        });
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }
}

