/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public abstract class DelegatingTransactionManager
implements TransactionManager {
    private final TransactionManager delegate;

    protected DelegatingTransactionManager(TransactionManager delegate) {
        this.delegate = delegate;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.commit();
    }

    public int getStatus() throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        return this.delegate.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.resume(transaction);
    }

    public void rollback() throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        this.delegate.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        if (this.delegate == null) {
            throw new SystemException("delegate == null");
        }
        return this.delegate.suspend();
    }
}

