/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.cdi.DelegatingTransactionManager;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Event;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionScoped;

@ApplicationScoped
class NarayanaTransactionManager
extends DelegatingTransactionManager {
    private final Event<Transaction> transactionScopeInitializedBroadcaster;
    private final Event<Object> transactionScopeDestroyedBroadcaster;

    @Deprecated
    NarayanaTransactionManager() {
        super(null);
        this.transactionScopeDestroyedBroadcaster = null;
        this.transactionScopeInitializedBroadcaster = null;
    }

    @Inject
    NarayanaTransactionManager(BeanManager beanManager, @Initialized(value=TransactionScoped.class) Event<Transaction> transactionScopeInitializedBroadcaster, @Destroyed(value=TransactionScoped.class) Event<Object> transactionScopeDestroyedBroadcaster) {
        super(NarayanaTransactionManager.getDelegate(beanManager));
        this.transactionScopeInitializedBroadcaster = transactionScopeInitializedBroadcaster;
        this.transactionScopeDestroyedBroadcaster = transactionScopeDestroyedBroadcaster;
    }

    private static final javax.transaction.TransactionManager getDelegate(BeanManager beanManager) {
        InitialContext initialContext;
        InitialContext temp = null;
        try {
            temp = new InitialContext();
        }
        catch (NoInitialContextException noInitialContextException) {
        }
        catch (NamingException namingException) {
            throw new CreationException(namingException.getMessage(), (Throwable)namingException);
        }
        finally {
            InitialContext initialContext2 = temp;
        }
        javax.transaction.TransactionManager candidateTransactionManager = null;
        if (initialContext != null) {
            JTAEnvironmentBean jtaEnvironmentBean = null;
            try {
                Set beans = beanManager == null ? null : beanManager.getBeans(JTAEnvironmentBean.class, new Annotation[0]);
                if (beans == null || beans.isEmpty()) {
                    jtaEnvironmentBean = jtaPropertyManager.getJTAEnvironmentBean();
                } else {
                    Bean bean = beanManager.resolve(beans);
                    assert (bean != null);
                    jtaEnvironmentBean = (JTAEnvironmentBean)beanManager.getReference(bean, JTAEnvironmentBean.class, beanManager.createCreationalContext((Contextual)bean));
                }
            }
            catch (RuntimeException runtimeException) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    runtimeException.addSuppressed(namingException);
                    throw runtimeException;
                }
            }
            assert (jtaEnvironmentBean != null);
            CreationException e = null;
            try {
                candidateTransactionManager = (javax.transaction.TransactionManager)initialContext.lookup(jtaEnvironmentBean.getTransactionManagerJNDIContext());
            }
            catch (NoInitialContextException namingException) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException2) {
                    if (e != null) {
                        e.addSuppressed((Throwable)namingException2);
                    } else {
                        e = new CreationException(namingException2.getMessage(), (Throwable)namingException2);
                    }
                    throw e;
                }
            }
            catch (NamingException namingException) {
                e = new CreationException(namingException.getMessage(), (Throwable)namingException);
                throw e;
            }
            finally {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    if (e != null) {
                        e.addSuppressed((Throwable)namingException);
                    } else {
                        e = new CreationException(namingException.getMessage(), (Throwable)namingException);
                    }
                    throw e;
                }
            }
        }
        if (candidateTransactionManager == null) {
            candidateTransactionManager = TransactionManager.transactionManager();
        }
        return candidateTransactionManager;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        super.begin();
        if (this.transactionScopeInitializedBroadcaster != null) {
            this.transactionScopeInitializedBroadcaster.fire((Object)this.getTransaction());
        }
    }

    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        try {
            super.commit();
        }
        finally {
            if (this.transactionScopeDestroyedBroadcaster != null) {
                this.transactionScopeDestroyedBroadcaster.fire((Object)this.toString());
            }
        }
    }

    @Override
    public void rollback() throws SystemException {
        try {
            super.rollback();
        }
        finally {
            if (this.transactionScopeDestroyedBroadcaster != null) {
                this.transactionScopeDestroyedBroadcaster.fire((Object)this.toString());
            }
        }
    }
}

