/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.bind.config.PropertyNamingStrategy;
import org.eclipse.yasson.internal.model.customization.naming.CaseInsensitiveStrategy;
import org.eclipse.yasson.internal.model.customization.naming.IdentityStrategy;
import org.eclipse.yasson.internal.model.customization.naming.LowerCaseWithDashesStrategy;
import org.eclipse.yasson.internal.model.customization.naming.LowerCaseWithUnderscoresStrategy;
import org.eclipse.yasson.internal.model.customization.naming.UpperCamelCaseStrategy;
import org.eclipse.yasson.internal.model.customization.naming.UpperCamelCaseWithSpacesStrategy;

public class DefaultNamingStrategies {
    private static final Map<String, PropertyNamingStrategy> strategies;

    public static PropertyNamingStrategy getStrategy(String strategyName) {
        return strategies.get(strategyName);
    }

    static {
        HashMap<String, Object> collector = new HashMap<String, Object>();
        collector.put("LOWER_CASE_WITH_UNDERSCORES", new LowerCaseWithUnderscoresStrategy());
        collector.put("LOWER_CASE_WITH_DASHES", new LowerCaseWithDashesStrategy());
        collector.put("UPPER_CAMEL_CASE", new UpperCamelCaseStrategy());
        collector.put("UPPER_CAMEL_CASE_WITH_SPACES", new UpperCamelCaseWithSpacesStrategy());
        collector.put("IDENTITY", new IdentityStrategy());
        collector.put("CASE_INSENSITIVE", new CaseInsensitiveStrategy());
        strategies = Collections.unmodifiableMap(collector);
    }
}

