/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.codec.ByteBufferDecoder;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.AmqpHeader;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.SaslFrameHandler;
import org.apache.qpid.proton.engine.impl.TransportImpl;

class SaslFrameParser {
    private static final String HEADER_DESCRIPTION = "SASL";
    private SaslFrameHandler _sasl;
    private State _state = State.HEADER0;
    private int _size;
    private ByteBuffer _buffer;
    private final ByteBufferDecoder _decoder;
    private int _frameSizeLimit;
    private TransportImpl _transport;

    SaslFrameParser(SaslFrameHandler sasl, ByteBufferDecoder decoder, int frameSizeLimit, TransportImpl transport) {
        this._sasl = sasl;
        this._decoder = decoder;
        this._frameSizeLimit = frameSizeLimit;
        this._transport = transport;
    }

    public void input(ByteBuffer input) throws TransportException {
        TransportException frameParsingError = null;
        int size = this._size;
        State state = this._state;
        ByteBuffer oldIn = null;
        while (input.hasRemaining() && state != State.ERROR && !this._sasl.isDone()) {
            switch (state) {
                case HEADER0: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[0]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[0], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER1;
                }
                case HEADER1: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[1]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[1], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER2;
                }
                case HEADER2: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[2]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[2], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER3;
                }
                case HEADER3: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[3]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[3], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER4;
                }
                case HEADER4: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[4]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[4], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER5;
                }
                case HEADER5: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[5]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[5], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER6;
                }
                case HEADER6: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[6]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[6], state});
                        state = State.ERROR;
                        break;
                    }
                    state = State.HEADER7;
                }
                case HEADER7: {
                    if (!input.hasRemaining()) break;
                    byte c = input.get();
                    if (c != AmqpHeader.SASL_HEADER[7]) {
                        frameParsingError = new TransportException("AMQP SASL header mismatch value %x, expecting %x. In state: %s", new Object[]{c, AmqpHeader.SASL_HEADER[7], state});
                        state = State.ERROR;
                        break;
                    }
                    this.logHeader();
                    state = State.SIZE_0;
                }
                case SIZE_0: {
                    if (!input.hasRemaining()) break;
                    if (input.remaining() >= 4) {
                        size = input.getInt();
                        state = State.PRE_PARSE;
                        break;
                    }
                    size = input.get() << 24 & 0xFF000000;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_1;
                        break;
                    }
                }
                case SIZE_1: {
                    size |= input.get() << 16 & 0xFF0000;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_2;
                        break;
                    }
                }
                case SIZE_2: {
                    size |= input.get() << 8 & 0xFF00;
                    if (!input.hasRemaining()) {
                        state = State.SIZE_3;
                        break;
                    }
                }
                case SIZE_3: {
                    size |= input.get() & 0xFF;
                    state = State.PRE_PARSE;
                }
                case PRE_PARSE: {
                    if (size < 8) {
                        frameParsingError = new TransportException("specified frame size %d smaller than minimum SASL frame header size 8", size);
                        state = State.ERROR;
                        break;
                    }
                    if (size > this._frameSizeLimit) {
                        frameParsingError = new TransportException("specified frame size %d larger than maximum SASL frame size %d", size, this._frameSizeLimit);
                        state = State.ERROR;
                        break;
                    }
                    if (input.remaining() < size - 4) {
                        this._buffer = ByteBuffer.allocate(size - 4);
                        this._buffer.put(input);
                        state = State.BUFFERING;
                        break;
                    }
                }
                case BUFFERING: {
                    if (this._buffer != null) {
                        if (input.remaining() < this._buffer.remaining()) {
                            this._buffer.put(input);
                            break;
                        }
                        ByteBuffer dup = input.duplicate();
                        dup.limit(dup.position() + this._buffer.remaining());
                        input.position(input.position() + this._buffer.remaining());
                        this._buffer.put(dup);
                        oldIn = input;
                        this._buffer.flip();
                        input = this._buffer;
                        state = State.PARSING;
                    }
                }
                case PARSING: {
                    int dataOffset = input.get() << 2 & 0x3FF;
                    if (dataOffset < 8) {
                        frameParsingError = new TransportException("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset > size) {
                        frameParsingError = new TransportException("specified frame data offset %d larger than the frame size %d", dataOffset, size);
                        state = State.ERROR;
                        break;
                    }
                    int type = input.get() & 0xFF;
                    input.get();
                    input.get();
                    if (type != 1) {
                        frameParsingError = new TransportException("unknown frame type: %d", type);
                        state = State.ERROR;
                        break;
                    }
                    if (dataOffset != 8) {
                        input.position(input.position() + dataOffset - 8);
                    }
                    if (oldIn == null) {
                        oldIn = input;
                        input = input.duplicate();
                        int endPos = input.position() + size - dataOffset;
                        input.limit(endPos);
                        oldIn.position(endPos);
                    }
                    try {
                        Binary payload;
                        this._decoder.setByteBuffer(input);
                        Object val = this._decoder.readObject();
                        if (input.hasRemaining()) {
                            byte[] payloadBytes = new byte[input.remaining()];
                            input.get(payloadBytes);
                            payload = new Binary(payloadBytes);
                        } else {
                            payload = null;
                        }
                        if (val instanceof SaslFrameBody) {
                            SaslFrameBody frameBody = (SaslFrameBody)val;
                            this._sasl.handle(frameBody, payload);
                            this.reset();
                            input = oldIn;
                            oldIn = null;
                            this._buffer = null;
                            state = State.SIZE_0;
                            break;
                        }
                        state = State.ERROR;
                        frameParsingError = new TransportException("Unexpected frame type encountered. Found a %s which does not implement %s", val == null ? "null" : val.getClass(), SaslFrameBody.class);
                    }
                    catch (DecodeException ex) {
                        state = State.ERROR;
                        frameParsingError = new TransportException(ex);
                    }
                    break;
                }
            }
        }
        this._state = state;
        this._size = size;
        if (this._state == State.ERROR) {
            if (frameParsingError != null) {
                throw frameParsingError;
            }
            throw new TransportException("Unable to parse, probably because of a previous error");
        }
    }

    private void reset() {
        this._size = 0;
        this._state = State.SIZE_0;
    }

    private void logHeader() {
        if (this._transport.isFrameTracingEnabled()) {
            this._transport.log(TransportImpl.INCOMING, HEADER_DESCRIPTION);
            ProtocolTracer tracer = this._transport.getProtocolTracer();
            if (tracer != null) {
                tracer.receivedHeader(HEADER_DESCRIPTION);
            }
        }
    }

    static enum State {
        HEADER0,
        HEADER1,
        HEADER2,
        HEADER3,
        HEADER4,
        HEADER5,
        HEADER6,
        HEADER7,
        SIZE_0,
        SIZE_1,
        SIZE_2,
        SIZE_3,
        PRE_PARSE,
        BUFFERING,
        PARSING,
        ERROR;

    }
}

