/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ElytronManagedThreadFactory
extends ManagedThreadFactoryImpl {
    private final AccessControlContext accessControlContext = AccessController.getContext();

    public ElytronManagedThreadFactory(String name, ContextServiceImpl contextService, int priority) {
        super(name, contextService, priority);
    }

    protected AbstractManagedThread createThread(Runnable r, ContextHandle contextHandleForSetup) {
        if (contextHandleForSetup != null) {
            r = SecurityIdentityUtils.doIdentityWrap(r);
        }
        AbstractManagedThread t = AccessController.doPrivileged(new CreateThreadAction(r, contextHandleForSetup), this.accessControlContext);
        if (!WildFlySecurityManager.isChecking()) {
            t.setContextClassLoader(null);
        } else {
            AccessController.doPrivileged(() -> {
                t.setContextClassLoader(null);
                return null;
            });
        }
        return t;
    }

    private final class CreateThreadAction
    implements PrivilegedAction<AbstractManagedThread> {
        private final Runnable r;
        private final ContextHandle contextHandleForSetup;

        private CreateThreadAction(Runnable r, ContextHandle contextHandleForSetup) {
            this.r = r;
            this.contextHandleForSetup = contextHandleForSetup;
        }

        @Override
        public AbstractManagedThread run() {
            return ElytronManagedThreadFactory.super.createThread(this.r, this.contextHandleForSetup);
        }
    }
}

