/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AbstractAegisIoImpl;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.AegisWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public class AegisXMLStreamDataWriter
extends AbstractAegisIoImpl
implements AegisWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(AegisXMLStreamDataWriter.class);

    AegisXMLStreamDataWriter(AegisContext globalContext) {
        super(globalContext);
    }

    @Override
    public void write(Object obj, QName elementName, boolean optional, XMLStreamWriter output, AegisType aegisType) throws Exception {
        ElementWriter writer;
        if (obj == null && aegisType == null && !optional) {
            Message message = new Message("WRITE_NULL_NEEDS_TYPE", LOG, new Object[0]);
            throw new DatabindingException(message);
        }
        if (obj != null && aegisType == null && (aegisType = this.getContext().getTypeMapping().getType(obj.getClass())) == null) {
            TypeCreator creator = this.getContext().getTypeMapping().getTypeCreator();
            aegisType = creator.createType(obj.getClass());
        }
        if (obj != null) {
            aegisType = TypeUtil.getWriteType(this.aegisContext, obj, aegisType);
        }
        if (aegisType == null) {
            Message message = new Message("WRITE_NEEDS_TYPE", LOG, new Object[]{obj});
            throw new DatabindingException(message);
        }
        if (obj == null) {
            if (optional) {
                return;
            }
            if (aegisType.isNillable() && aegisType.isWriteOuter()) {
                writer = new ElementWriter(output);
                MessageWriter w2 = writer.getElementWriter(elementName);
                w2.writeXsiNil();
                w2.close();
                return;
            }
        }
        writer = new ElementWriter(output);
        MessageWriter w2 = writer.getElementWriter(elementName);
        if (this.getContext().isWriteXsiTypes() && aegisType.getSchemaType() != null) {
            w2.writeXsiType(aegisType.getSchemaType());
        }
        aegisType.writeObject(obj, w2, this.context);
        w2.close();
    }

    @Override
    public void write(Object obj, QName elementName, boolean optional, XMLStreamWriter output, Type objectType) throws Exception {
        AegisType aegisType = null;
        if (objectType instanceof Class) {
            aegisType = this.getContext().getTypeMapping().getType(objectType);
        }
        if (aegisType == null) {
            TypeCreator creator = this.getContext().getTypeMapping().getTypeCreator();
            aegisType = creator.createType(objectType);
        }
        if (aegisType == null) {
            Message message = new Message("NO_MAPPING_FOR_TYPE", LOG, new Object[]{objectType});
            throw new DatabindingException(message);
        }
        this.write(obj, elementName, optional, output, aegisType);
    }
}

