/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.common.i18n.Message;

public class DatabindingException
extends RuntimeException {
    private static final long serialVersionUID = -2595633596348811788L;
    private final List<String> extraMessages = new LinkedList<String>();

    public DatabindingException(String message) {
        super(message);
    }

    public DatabindingException(String message, Throwable cause) {
        super(message, cause);
    }

    public DatabindingException(Message message) {
        super(message.toString());
    }

    public DatabindingException(Message message, Throwable cause) {
        super(message.toString(), cause);
    }

    @Override
    public String getMessage() {
        if (this.getCause() == null || this.getCause() == this) {
            return this.getActualMessage();
        }
        return this.getActualMessage() + ". Nested exception is " + this.getCause().getClass().getName() + ": " + this.getCause().getMessage();
    }

    public String getActualMessage() {
        if (this.extraMessages.isEmpty()) {
            return super.getMessage();
        }
        StringBuilder buf = new StringBuilder();
        for (String s : this.extraMessages) {
            buf.append(s);
        }
        buf.append(' ');
        buf.append(super.getMessage());
        return buf.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.getCause() == null || this.getCause() == this) {
            super.printStackTrace(s);
        } else {
            s.println(this);
            this.getCause().printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        if (this.getCause() == null || this.getCause() == this) {
            super.printStackTrace(w);
        } else {
            w.println(this);
            this.getCause().printStackTrace(w);
        }
    }

    public final void prepend(String m) {
        this.extraMessages.add(0, m + ": ");
    }

    public void setMessage(String s) {
        this.extraMessages.clear();
        this.extraMessages.add(s);
    }
}

