/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

public class PrivilegedServiceHelper {
    private static final PrivilegedServiceHelper INSTANCE = new PrivilegedServiceHelper();

    private PrivilegedServiceHelper() {
    }

    public static PrivilegedServiceHelper getInstance() {
        return INSTANCE;
    }

    public <T> T getPort(final Service service, final QName portName, final Class<T> serviceEndpointInterface) {
        if (System.getSecurityManager() == null) {
            return (T)service.getPort(portName, serviceEndpointInterface);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return service.getPort(portName, serviceEndpointInterface);
            }
        });
    }

    public <T> T getPort(final Service service, final QName portName, final Class<T> serviceEndpointInterface, final WebServiceFeature ... features) {
        if (System.getSecurityManager() == null) {
            return (T)service.getPort(portName, serviceEndpointInterface, features);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return service.getPort(portName, serviceEndpointInterface, features);
            }
        });
    }

    public <T> T getPort(final Service service, final EndpointReference endpointReference, final Class<T> serviceEndpointInterface, final WebServiceFeature ... features) {
        if (System.getSecurityManager() == null) {
            return (T)service.getPort(endpointReference, serviceEndpointInterface, features);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return service.getPort(endpointReference, serviceEndpointInterface, features);
            }
        });
    }

    public <T> T getPort(final Service service, final Class<T> serviceEndpointInterface, final WebServiceFeature ... features) {
        if (System.getSecurityManager() == null) {
            return (T)service.getPort(serviceEndpointInterface, features);
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return service.getPort(serviceEndpointInterface, features);
            }
        });
    }
}

