/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;

public class FederationQueuePolicyConfiguration
implements FederationPolicy<FederationQueuePolicyConfiguration>,
Serializable {
    private String name;
    private boolean includeFederated;
    private Set<Matcher> includes = new HashSet<Matcher>();
    private Set<Matcher> excludes = new HashSet<Matcher>();
    private Integer priorityAdjustment;
    private String transformerRef;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FederationQueuePolicyConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Set<Matcher> getIncludes() {
        return this.includes;
    }

    public Set<Matcher> getExcludes() {
        return this.excludes;
    }

    public FederationQueuePolicyConfiguration addInclude(Matcher include) {
        this.includes.add(include);
        return this;
    }

    public FederationQueuePolicyConfiguration addExclude(Matcher exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public boolean isIncludeFederated() {
        return this.includeFederated;
    }

    public FederationQueuePolicyConfiguration setIncludeFederated(boolean includeFederated) {
        this.includeFederated = includeFederated;
        return this;
    }

    public Integer getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public FederationQueuePolicyConfiguration setPriorityAdjustment(Integer priorityAdjustment) {
        this.priorityAdjustment = priorityAdjustment;
        return this;
    }

    public String getTransformerRef() {
        return this.transformerRef;
    }

    public FederationQueuePolicyConfiguration setTransformerRef(String transformerRef) {
        this.transformerRef = transformerRef;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationQueuePolicyConfiguration)) {
            return false;
        }
        FederationQueuePolicyConfiguration that = (FederationQueuePolicyConfiguration)o;
        return this.includeFederated == that.includeFederated && Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.priorityAdjustment, that.priorityAdjustment) && Objects.equals(this.transformerRef, that.transformerRef);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includeFederated, this.includes, this.excludes, this.priorityAdjustment, this.transformerRef);
    }

    public static class Matcher
    implements Serializable {
        private String queueMatch;
        private String addressMatch;

        public String getQueueMatch() {
            return this.queueMatch;
        }

        public Matcher setQueueMatch(String queueMatch) {
            this.queueMatch = queueMatch;
            return this;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public Matcher setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Matcher)) {
                return false;
            }
            Matcher matcher = (Matcher)o;
            return Objects.equals(this.queueMatch, matcher.queueMatch) && Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.queueMatch, this.addressMatch);
        }
    }
}

