/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;

public class SimpleCDI
extends AbstractCDI<Object> {
    private final ComputingCache<String, BeanManagerProxy> beanManagers;
    private final Container container;

    public SimpleCDI() {
        this(Container.instance());
    }

    public SimpleCDI(Container container) {
        this.container = container;
        this.beanManagers = ComputingCacheBuilder.newBuilder().setWeakValues().build(new ClassNameToBeanManager());
    }

    protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
        throw BeanManagerLogger.LOG.unsatisfiedBeanManager(callerClassName);
    }

    protected BeanManagerImpl ambiguousBeanManager(String callerClassName, Set<BeanManagerImpl> managers) {
        throw BeanManagerLogger.LOG.ambiguousBeanManager(callerClassName);
    }

    public BeanManagerProxy getBeanManager() {
        ContainerState state = this.container.getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw BeanManagerLogger.LOG.beanManagerNotAvailable();
        }
        return this.beanManagers.getValue(this.getCallingClassName());
    }

    public String toString() {
        return "Weld";
    }

    protected Container getContainer() {
        return this.container;
    }

    public void cleanup() {
        this.beanManagers.clear();
    }

    private class ClassNameToBeanManager
    implements Function<String, BeanManagerProxy> {
        private ClassNameToBeanManager() {
        }

        @Override
        public BeanManagerProxy apply(String callerClassName) {
            return new BeanManagerProxy(this.findBeanManager(callerClassName));
        }

        public BeanManagerImpl findBeanManager(String callerClassName) {
            if (callerClassName == null) {
                throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
            }
            HashSet<BeanManagerImpl> managers = new HashSet<BeanManagerImpl>();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : SimpleCDI.this.container.beanDeploymentArchives().entrySet()) {
                for (String className : entry.getKey().getKnownClasses()) {
                    if (!className.equals(callerClassName)) continue;
                    managers.add(entry.getValue());
                }
            }
            if (managers.size() == 1) {
                return (BeanManagerImpl)managers.iterator().next();
            }
            if (managers.size() == 0) {
                return SimpleCDI.this.unsatisfiedBeanManager(callerClassName);
            }
            return SimpleCDI.this.ambiguousBeanManager(callerClassName, managers);
        }
    }
}

