/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.injection.ResourceInjectionProcessor;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

public final class ResourceInjectionFactory
implements Service,
Iterable<ResourceInjectionProcessor<?, ?>> {
    private final List<ResourceInjectionProcessor<?, ?>> resourceInjectionProcessors = new CopyOnWriteArrayList();

    public ResourceInjectionFactory() {
        this.initializeProcessors();
    }

    public void addResourceInjectionProcessor(ResourceInjectionProcessor<?, ?> processor) {
        this.resourceInjectionProcessors.add(processor);
    }

    public List<Set<ResourceInjection<?>>> getResourceInjections(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        ArrayList result = new ArrayList();
        for (EnhancedAnnotatedType<?> actualType = type; actualType != null && !actualType.getJavaClass().equals(Object.class); actualType = actualType.getEnhancedSuperclass()) {
            Set<ResourceInjection<?>> resourceInjections = this.discoverType(declaringBean, actualType, manager);
            if (resourceInjections.isEmpty()) continue;
            result.add(resourceInjections);
        }
        Collections.reverse(result);
        return result;
    }

    public <T, X> ResourceInjection<T> getStaticProducerFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, BeanManagerImpl beanManager) {
        ResourceInjectionProcessor<?, ?> processor;
        ResourceInjection<T> resourceInjection = null;
        Iterator<ResourceInjectionProcessor<?, ?>> iterator = this.resourceInjectionProcessors.iterator();
        while (iterator.hasNext() && (resourceInjection = (processor = iterator.next()).createStaticProducerFieldResourceInjection(fieldInjectionPoint, beanManager)) == null) {
        }
        return resourceInjection;
    }

    private void initializeProcessors() {
        this.resourceInjectionProcessors.add(new PersistenceUnitResourceInjectionProcessor());
        this.resourceInjectionProcessors.add(new PersistenceContextResourceInjectionProcessor());
        this.resourceInjectionProcessors.add(new ResourceResourceInjectionProcessor());
        this.resourceInjectionProcessors.add(new WebServiceResourceInjectionProcessor());
    }

    private Set<ResourceInjection<?>> discoverType(Bean<?> bean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        HashSet resourceInjections = new HashSet();
        for (ResourceInjectionProcessor<?, ?> processor : this.resourceInjectionProcessors) {
            resourceInjections.addAll(processor.createResourceInjections(bean, type, manager));
        }
        return resourceInjections;
    }

    public void cleanup() {
    }

    @Override
    public Iterator<ResourceInjectionProcessor<?, ?>> iterator() {
        return this.resourceInjectionProcessors.iterator();
    }

    private static class WebServiceResourceInjectionProcessor
    extends ResourceInjectionProcessor<JaxwsInjectionServices, WSApiAbstraction> {
        private WebServiceResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JaxwsInjectionServices injectionServices, WSApiAbstraction apiAbstraction) {
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerWebServiceRefInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(WSApiAbstraction apiAbstraction) {
            return apiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS;
        }

        @Override
        protected WSApiAbstraction getProcessorContext(BeanManagerImpl manager) {
            return (WSApiAbstraction)manager.getServices().get(WSApiAbstraction.class);
        }

        @Override
        protected JaxwsInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return (JaxwsInjectionServices)manager.getServices().get(JaxwsInjectionServices.class);
        }
    }

    private static class ResourceResourceInjectionProcessor
    extends ResourceInjectionProcessor<ResourceInjectionServices, Object> {
        private ResourceResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, ResourceInjectionServices injectionServices, Object processorContext) {
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerResourceInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(Object processorContext) {
            return Resource.class;
        }

        @Override
        protected Object getProcessorContext(BeanManagerImpl manager) {
            return null;
        }

        @Override
        protected ResourceInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return (ResourceInjectionServices)manager.getServices().get(ResourceInjectionServices.class);
        }
    }

    private static class PersistenceContextResourceInjectionProcessor
    extends ResourceInjectionProcessor<JpaInjectionServices, PersistenceApiAbstraction> {
        private PersistenceContextResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JpaInjectionServices injectionServices, PersistenceApiAbstraction apiAbstraction) {
            if (!injectionPoint.getType().equals(apiAbstraction.ENTITY_MANAGER_CLASS)) {
                throw BeanLogger.LOG.invalidResourceProducerType(injectionPoint.getAnnotated(), apiAbstraction.ENTITY_MANAGER_CLASS);
            }
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceContextInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction apiAbstraction) {
            return apiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
        }

        @Override
        protected PersistenceApiAbstraction getProcessorContext(BeanManagerImpl manager) {
            return (PersistenceApiAbstraction)manager.getServices().get(PersistenceApiAbstraction.class);
        }

        @Override
        protected JpaInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return (JpaInjectionServices)manager.getServices().get(JpaInjectionServices.class);
        }

        @Override
        protected boolean accept(AnnotatedMember<?> member, PersistenceApiAbstraction apiAbstraction) {
            return !apiAbstraction.SESSION_NAME.equals(Reflections.getRawType(this.getResourceInjectionPointType(member)).getName());
        }
    }

    private static class PersistenceUnitResourceInjectionProcessor
    extends ResourceInjectionProcessor<JpaInjectionServices, PersistenceApiAbstraction> {
        private PersistenceUnitResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JpaInjectionServices injectionServices, PersistenceApiAbstraction apiAbstraction) {
            if (!injectionPoint.getType().equals(apiAbstraction.ENTITY_MANAGER_FACTORY_CLASS)) {
                throw BeanLogger.LOG.invalidResourceProducerType(injectionPoint.getAnnotated(), apiAbstraction.ENTITY_MANAGER_FACTORY_CLASS);
            }
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceUnitInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction apiAbstraction) {
            return apiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS;
        }

        @Override
        protected PersistenceApiAbstraction getProcessorContext(BeanManagerImpl manager) {
            return (PersistenceApiAbstraction)manager.getServices().get(PersistenceApiAbstraction.class);
        }

        @Override
        protected JpaInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return (JpaInjectionServices)manager.getServices().get(JpaInjectionServices.class);
        }

        @Override
        protected boolean accept(AnnotatedMember<?> member, PersistenceApiAbstraction apiAbstraction) {
            return !apiAbstraction.SESSION_FACTORY_NAME.equals(Reflections.getRawType(this.getResourceInjectionPointType(member)).getName());
        }
    }
}

