/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.ClusterConnectionAdd;
import org.wildfly.extension.messaging.activemq.ClusterConnectionControlHandler;
import org.wildfly.extension.messaging.activemq.ClusterConnectionRemove;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.InfiniteOrPositiveValidators;
import org.wildfly.extension.messaging.activemq.MessagingExtension;

public class ClusterConnectionDefinition
extends PersistentResourceDefinition {
    public static final String GET_NODES = "get-nodes";
    public static final SimpleAttributeDefinition ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-connection-address", (ModelType)ModelType.STRING).setXmlName("address")).setDefaultValue(null)).setValidator((ParameterValidator)new StringLengthValidator(0))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ALLOW_DIRECT_CONNECTIONS_ONLY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"allow-direct-connections-only", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).setRequires(new String[]{"static-connectors"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CALL_FAILOVER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT).setDefaultValue(new ModelNode(-1L))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CHECK_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(30000L))).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(60000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTOR_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connector-name", (ModelType)ModelType.STRING).setRestartAllServices()).build();
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("static-connectors").setRequired(true)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAlternatives(new String[]{"discovery-group"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group", (ModelType)ModelType.STRING).setRequired(true)).setAlternatives(new String[]{CONNECTOR_REFS.getName()})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_LOAD_BALANCING_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-load-balancing-type", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(MessageLoadBalancingType.ON_DEMAND.toString()))).setValidator((ParameterValidator)new EnumValidator(MessageLoadBalancingType.class, true, true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_HOPS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-hops", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(1))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MAX_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(2000L))).setRequired(false)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition NOTIFICATION_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"notification-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(2))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition NOTIFICATION_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"notification-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(1000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PRODUCER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(500L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RETRY_INTERVAL_MULTIPLIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.DOUBLE).setDefaultValue(new ModelNode(1.0))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADDRESS, CONNECTOR_NAME, CHECK_PERIOD, CONNECTION_TTL, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CALL_TIMEOUT, CALL_FAILOVER_TIMEOUT, RETRY_INTERVAL, RETRY_INTERVAL_MULTIPLIER, MAX_RETRY_INTERVAL, INITIAL_CONNECT_ATTEMPTS, RECONNECT_ATTEMPTS, USE_DUPLICATE_DETECTION, MESSAGE_LOAD_BALANCING_TYPE, MAX_HOPS, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, PRODUCER_WINDOW_SIZE, NOTIFICATION_ATTEMPTS, NOTIFICATION_INTERVAL, CONNECTOR_REFS, ALLOW_DIRECT_CONNECTIONS_ONLY, DISCOVERY_GROUP_NAME};
    public static final SimpleAttributeDefinition NODE_ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"node-id", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition TOPOLOGY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"topology", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    public static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{TOPOLOGY, NODE_ID};
    private final boolean registerRuntimeOnly;

    ClusterConnectionDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.CLUSTER_CONNECTION_PATH, MessagingExtension.getResourceDescriptionResolver("cluster-connection"), (OperationStepHandler)ClusterConnectionAdd.INSTANCE, (OperationStepHandler)ClusterConnectionRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
        }
        ClusterConnectionControlHandler.INSTANCE.registerAttributes(registry);
        for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)ClusterConnectionControlHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ClusterConnectionControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            SimpleOperationDefinition getNodesDef = new SimpleOperationDefinitionBuilder(GET_NODES, this.getResourceDescriptionResolver()).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.STRING).build();
            registry.registerOperationHandler((OperationDefinition)getNodesDef, (OperationStepHandler)ClusterConnectionControlHandler.INSTANCE);
        }
    }

    private static enum MessageLoadBalancingType {
        OFF,
        STRICT,
        ON_DEMAND;

    }
}

