/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.store.spi.LockFactoryCreator;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DirectoryProviderHelper {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final String ROOT_INDEX_PROP_NAME = "sourceBase";
    private static final String RELATIVE_INDEX_PROP_NAME = "source";
    @Deprecated
    private static final String COPY_BUFFER_SIZE_PROP_NAME = "buffer_size_on_copy";
    private static final String FS_DIRECTORY_TYPE_PROP_NAME = "filesystem_access_type";
    private static final String REFRESH_PROP_NAME = "refresh";
    private static final String RETRY_INITIALIZE_PROP_NAME = "retry_initialize_period";

    private DirectoryProviderHelper() {
    }

    public static Path getSourceDirectoryPath(String indexName, Properties properties, boolean needWritePermissions) {
        Path sourceDirectory;
        String root = properties.getProperty(ROOT_INDEX_PROP_NAME);
        String relative = properties.getProperty(RELATIVE_INDEX_PROP_NAME);
        if (log.isTraceEnabled()) {
            log.trace("Guess source directory from sourceBase " + (root != null ? root : "<null>") + " and " + RELATIVE_INDEX_PROP_NAME + " " + (relative != null ? relative : "<null>"));
        }
        if (relative == null) {
            relative = indexName;
        }
        if (StringHelper.isEmpty(root)) {
            log.debug("No root directory, go with relative " + relative);
            sourceDirectory = FileSystems.getDefault().getPath(relative, new String[0]);
            if (Files.notExists(sourceDirectory, new LinkOption[0])) {
                throw log.sourceDirectoryNotExisting(relative);
            }
            if (!Files.isReadable(sourceDirectory)) {
                throw log.directoryIsNotReadable(relative);
            }
            if (!Files.isDirectory(sourceDirectory, new LinkOption[0])) {
                throw log.fileIsADirectory(relative);
            }
        } else {
            Path rootDir = FileSystems.getDefault().getPath(root, new String[0]);
            DirectoryProviderHelper.makeSanityCheckedDirectory(rootDir, indexName, needWritePermissions);
            sourceDirectory = rootDir.resolve(relative);
            DirectoryProviderHelper.makeSanityCheckedDirectory(sourceDirectory, indexName, needWritePermissions);
            log.debug("Got directory from root + relative");
        }
        return sourceDirectory;
    }

    public static FSDirectory createFSIndex(Path indexDir, Properties properties, ServiceManager serviceManager) throws IOException {
        LockFactory lockFactory = DirectoryProviderHelper.getLockFactory(indexDir, properties, serviceManager);
        FSDirectoryType fsDirectoryType = FSDirectoryType.getType(properties);
        FSDirectory fsDirectory = fsDirectoryType.getDirectory(indexDir, lockFactory);
        log.debugf("Initialize index: '%s'", indexDir.toAbsolutePath());
        DirectoryHelper.initializeIndexIfNeeded((Directory)fsDirectory);
        return fsDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LockFactory getLockFactory(Path indexDir, Properties properties, ServiceManager serviceManager) {
        try {
            LockFactory lockFactory = serviceManager.requestService(LockFactoryCreator.class).createLockFactory(indexDir, properties);
            return lockFactory;
        }
        finally {
            serviceManager.releaseService(LockFactoryCreator.class);
        }
    }

    public static void makeSanityCheckedDirectory(Path directory, String indexName, boolean verifyIsWritable) {
        if (Files.notExists(directory, new LinkOption[0])) {
            log.indexDirectoryNotFoundCreatingNewOne(directory.toString());
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SearchException("Unable to create index directory: " + directory + " for index " + indexName);
            }
        } else if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new SearchException("Unable to initialize index: " + indexName + ": " + directory + " is a file.");
        }
        if (verifyIsWritable && !Files.isWritable(directory)) {
            throw new SearchException("Cannot write into index directory: " + directory + " for index " + indexName);
        }
    }

    static long getRetryInitializePeriod(Properties properties, String directoryProviderName) {
        int retry_period_seconds = ConfigurationParseHelper.getIntValue(properties, RETRY_INITIALIZE_PROP_NAME, 0);
        log.debugf("Retry initialize period for Directory %s: %d seconds", directoryProviderName, retry_period_seconds);
        if (retry_period_seconds < 0) {
            throw new SearchException("retry_initialize_period for Directory " + directoryProviderName + " must be a positive integer");
        }
        return retry_period_seconds * 1000;
    }

    static long getRefreshPeriod(Properties properties, String directoryProviderName) {
        long period;
        String refreshPeriod = properties.getProperty(REFRESH_PROP_NAME, "3600");
        try {
            period = Long.parseLong(refreshPeriod);
        }
        catch (NumberFormatException nfe) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName + "; refresh period is not numeric.", nfe);
        }
        log.debugf("Refresh period: %d seconds", period);
        return period * 1000L;
    }

    @Deprecated
    public static long getCopyBufferSize(String indexName, Properties properties) {
        String value = properties.getProperty(COPY_BUFFER_SIZE_PROP_NAME);
        if (value != null) {
            log.deprecatedConfigurationPropertyIsIgnored(COPY_BUFFER_SIZE_PROP_NAME);
        }
        return 0L;
    }

    private static enum FSDirectoryType {
        AUTO(null),
        SIMPLE(SimpleFSDirectory.class),
        NIO(NIOFSDirectory.class),
        MMAP(MMapDirectory.class);

        private Class<? extends FSDirectory> fsDirectoryClass;

        private FSDirectoryType(Class<? extends FSDirectory> fsDirectoryClass) {
            this.fsDirectoryClass = fsDirectoryClass;
        }

        public FSDirectory getDirectory(Path indexDir, LockFactory factory) throws IOException {
            FSDirectory directory;
            if (this.fsDirectoryClass == null) {
                directory = FSDirectory.open((Path)indexDir, (LockFactory)factory);
            } else {
                try {
                    Constructor<? extends FSDirectory> constructor = this.fsDirectoryClass.getConstructor(Path.class, LockFactory.class);
                    directory = constructor.newInstance(indexDir, factory);
                }
                catch (NoSuchMethodException e) {
                    throw new SearchException("Unable to find appropriate FSDirectory constructor", e);
                }
                catch (InstantiationException e) {
                    throw new SearchException("Unable to instantiate FSDirectory class " + this.fsDirectoryClass.getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new SearchException("Unable to instantiate FSDirectory class " + this.fsDirectoryClass.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new SearchException("Unable to instantiate FSDirectory class " + this.fsDirectoryClass.getName(), e);
                }
            }
            return directory;
        }

        public static FSDirectoryType getType(Properties properties) {
            FSDirectoryType fsDirectoryType;
            String fsDirectoryTypeValue = properties.getProperty(DirectoryProviderHelper.FS_DIRECTORY_TYPE_PROP_NAME);
            if (StringHelper.isNotEmpty(fsDirectoryTypeValue)) {
                try {
                    fsDirectoryType = Enum.valueOf(FSDirectoryType.class, fsDirectoryTypeValue.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException("Invalid option value for filesystem_access_type: " + fsDirectoryTypeValue);
                }
            } else {
                fsDirectoryType = AUTO;
            }
            return fsDirectoryType;
        }
    }
}

