/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential;

import java.util.List;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.annotation.StereotypeProperty;

public abstract class AbstractTokenConsumer<T extends Token>
implements Token.Consumer<T> {
    @Override
    public <I extends IdentityType> I extractIdentity(T token, Class<I> identityType, StereotypeProperty.Property stereotypeProperty, Object identifier) {
        if (token == null || token.getToken() == null) {
            throw IDMMessages.MESSAGES.nullArgument("Token");
        }
        if (identityType == null) {
            throw IDMMessages.MESSAGES.nullArgument("IdentityType");
        }
        if (stereotypeProperty == null) {
            throw IDMMessages.MESSAGES.nullArgument("Identifier value");
        }
        if (identifier == null) {
            throw IDMMessages.MESSAGES.nullArgument("Identifier value");
        }
        return this.extractIdentityTypeFromToken(token, identityType, stereotypeProperty, identifier);
    }

    protected abstract String extractSubject(T var1);

    protected abstract Set<String> extractRoles(T var1);

    protected abstract Set<String> extractGroups(T var1);

    private <I extends IdentityType> I extractIdentityTypeFromToken(T token, Class<I> identityType, StereotypeProperty.Property stereotypeProperty, Object identifier) {
        if (this.hasIdentityType(token, stereotypeProperty, identifier)) {
            try {
                IdentityType identityTypeInstance = (IdentityType)Reflections.newInstance(identityType);
                Property property = this.resolveProperty(identityType, stereotypeProperty);
                property.setValue((Object)identityTypeInstance, identifier);
                if (Account.class.isAssignableFrom(identityType)) {
                    Property userNameProperty = this.resolveProperty(identityType, StereotypeProperty.Property.IDENTITY_USER_NAME);
                    userNameProperty.setValue((Object)identityTypeInstance, (Object)this.extractSubject(token));
                }
                return (I)identityTypeInstance;
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not extract IdentityType [" + identityType + "] from Token [" + token + "].", e);
            }
        }
        return null;
    }

    private Property resolveProperty(Class<? extends IdentityType> identityType, StereotypeProperty.Property stereotypeProperty) {
        List properties = PropertyQueries.createQuery(identityType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(StereotypeProperty.class)).getResultList();
        if (properties.isEmpty()) {
            throw new IdentityManagementException("IdentityType [" + identityType + "] does not have any property mapped with " + StereotypeProperty.class + ".");
        }
        for (Property property : properties) {
            StereotypeProperty propertyStereotypeProperty = property.getAnnotatedElement().getAnnotation(StereotypeProperty.class);
            if (!stereotypeProperty.equals((Object)propertyStereotypeProperty.value())) continue;
            return property;
        }
        throw new IdentityManagementException("Could not resolve property in type [" + identityType + " for StereotypeProperty [" + (Object)((Object)stereotypeProperty) + ".");
    }

    private boolean hasIdentityType(T token, StereotypeProperty.Property stereotypeProperty, Object identifier) {
        String subject;
        Set<String> groupNames;
        Set<String> roleNames;
        if (StereotypeProperty.Property.IDENTITY_ROLE_NAME.equals((Object)stereotypeProperty) && (roleNames = this.extractRoles(token)).contains(identifier)) {
            return true;
        }
        if (StereotypeProperty.Property.IDENTITY_GROUP_NAME.equals((Object)stereotypeProperty) && (groupNames = this.extractGroups(token)).contains(identifier)) {
            return true;
        }
        return (StereotypeProperty.Property.IDENTITY_USER_NAME.equals((Object)stereotypeProperty) || StereotypeProperty.Property.IDENTITY_ID.equals((Object)stereotypeProperty)) && (subject = this.extractSubject(token)) != null && identifier.equals(subject);
    }
}

