/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;
import org.jboss.resteasy.jose.jwe.JWEHeader;
import org.jboss.resteasy.jose.jwe.crypto.DirectDecrypter;
import org.jboss.resteasy.jose.jwe.crypto.RSADecrypter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JWEInput {
    String wireString;
    String encodedHeader;
    String encodedKey;
    String encodedIv;
    String encodedContent;
    String encodedAuthTag;
    JWEHeader header;
    byte[] rawContent;
    Providers providers;
    private static ObjectMapper mapper = new ObjectMapper();

    public JWEInput(String wire) {
        this(wire, null);
    }

    public JWEInput(String wire, Providers providers) {
        this.providers = providers;
        this.wireString = wire;
        String[] parts = wire.split("\\.");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Parsing error");
        }
        this.encodedHeader = parts[0];
        this.encodedKey = parts[1];
        this.encodedIv = parts[2];
        this.encodedContent = parts[3];
        this.encodedAuthTag = parts[4];
        try {
            byte[] headerBytes = Base64Url.decode(this.encodedHeader);
            this.header = (JWEHeader)mapper.readValue(headerBytes, JWEHeader.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getWireString() {
        return this.wireString;
    }

    public JWEHeader getHeader() {
        return this.header;
    }

    public ContentReader decrypt(RSAPrivateKey privateKey) {
        Algorithm algorithm = this.header.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalStateException(Messages.MESSAGES.algorithmWasNull());
        }
        if (algorithm != Algorithm.RSA1_5 && algorithm != Algorithm.RSA_OAEP) {
            throw new IllegalStateException(Messages.MESSAGES.notEncryptedWithRSAalgorithm());
        }
        EncryptionMethod enc = this.header.getEncryptionMethod();
        if (algorithm == null) {
            throw new IllegalStateException(Messages.MESSAGES.encryptionMethodWasNull());
        }
        this.rawContent = RSADecrypter.decrypt(this.header, this.encodedHeader, this.encodedKey, this.encodedIv, this.encodedContent, this.encodedAuthTag, privateKey);
        return new ContentReader();
    }

    public ContentReader decrypt(String secret) {
        EncryptionMethod enc = this.header.getEncryptionMethod();
        if (enc == null) {
            throw new IllegalStateException(Messages.MESSAGES.encryptionMethodWasNull());
        }
        MessageDigest digest = enc.createSecretDigester();
        byte[] hash = digest.digest(secret.getBytes(StandardCharsets.UTF_8));
        return this.decrypt(hash);
    }

    public ContentReader decrypt(byte[] secret) {
        SecretKeySpec key = new SecretKeySpec(secret, "AES");
        return this.decrypt(key);
    }

    public ContentReader decrypt(SecretKey key) {
        Algorithm algorithm = this.header.getAlgorithm();
        if (algorithm == null) {
            throw new IllegalStateException(Messages.MESSAGES.algorithmWasNull());
        }
        if (algorithm != Algorithm.dir) {
            throw new IllegalStateException(Messages.MESSAGES.notEncryptedWithDirAlgorithm());
        }
        EncryptionMethod enc = this.header.getEncryptionMethod();
        if (enc == null) {
            throw new IllegalStateException(Messages.MESSAGES.encryptionMethodWasNull());
        }
        this.rawContent = DirectDecrypter.decrypt(key, this.header, this.encodedHeader, null, this.encodedIv, this.encodedContent, this.encodedAuthTag);
        return new ContentReader();
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public class ContentReader {
        public byte[] getRawContent() {
            return JWEInput.this.rawContent;
        }

        public <T> T readContent(Class<T> type) {
            MediaType mediaType = MediaType.WILDCARD_TYPE;
            if (JWEInput.this.header.getContentType() != null) {
                mediaType = MediaType.valueOf((String)JWEInput.this.header.getContentType());
            }
            return this.readContent(type, null, null, mediaType);
        }

        public <T> T readContent(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            MessageBodyReader reader;
            Providers tmp = JWEInput.this.providers;
            if (tmp == null) {
                tmp = ResteasyProviderFactory.getInstance();
            }
            if ((reader = tmp.getMessageBodyReader(type, genericType, annotations, mediaType)) == null) {
                throw new RuntimeException(Messages.MESSAGES.unableToFindReaderForContentType());
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(JWEInput.this.rawContent);
                return (T)reader.readFrom(type, genericType, annotations, mediaType, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)bais);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

