/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web.support;

import java.security.MessageDigest;
import org.picketlink.idm.credential.Digest;

public class HTTPDigestUtil {
    private static final String UTF8 = "UTF-8";
    private static final String MD5_ALGORITHM = "MD5";

    public static String[] quoteTokenize(String clientResponse) {
        if (clientResponse == null) {
            throw new IllegalArgumentException("Null client response.");
        }
        return clientResponse.split(",(?=(?:[^\"]*\"[^\"]*\")+$)");
    }

    public static String userName(String token) {
        if (token.startsWith("Digest")) {
            token = token.substring(7).trim();
        }
        return HTTPDigestUtil.extract(token, "username=");
    }

    public static String extract(String token, String key) {
        String result = null;
        if (token.startsWith(key)) {
            int eq = token.indexOf("=");
            result = token.substring(eq + 1);
            if (result.startsWith("\"")) {
                result = result.substring(1);
            }
            if (result.endsWith("\"")) {
                int len = result.length();
                result = result.substring(0, len - 1);
            }
        }
        return result;
    }

    public static Digest digest(String[] tokens) {
        String username = null;
        String realm = null;
        String nonce = null;
        String uri = null;
        String qop = null;
        String nc = null;
        String cnonce = null;
        String clientResponse = null;
        String opaque = null;
        String domain = null;
        String stale = "false";
        int len = tokens.length;
        for (int i = 0; i < len; ++i) {
            String token = tokens[i].trim();
            if (token.startsWith("Digest") || token.startsWith("username=")) {
                username = HTTPDigestUtil.userName(token);
                continue;
            }
            if (token.startsWith("realm")) {
                realm = HTTPDigestUtil.extract(token, "realm=");
                continue;
            }
            if (token.startsWith("nonce")) {
                nonce = HTTPDigestUtil.extract(token, "nonce=");
                continue;
            }
            if (token.startsWith("uri")) {
                uri = HTTPDigestUtil.extract(token, "uri=");
                continue;
            }
            if (token.startsWith("qop")) {
                qop = HTTPDigestUtil.extract(token, "qop=");
                continue;
            }
            if (token.startsWith("nc")) {
                nc = HTTPDigestUtil.extract(token, "nc=");
                continue;
            }
            if (token.startsWith("cnonce")) {
                cnonce = HTTPDigestUtil.extract(token, "cnonce=");
                continue;
            }
            if (token.startsWith("response")) {
                clientResponse = HTTPDigestUtil.extract(token, "response=");
                continue;
            }
            if (token.startsWith("opaque")) {
                opaque = HTTPDigestUtil.extract(token, "opaque=");
                continue;
            }
            if (token.startsWith("domain")) {
                domain = HTTPDigestUtil.extract(token, "domain=");
                continue;
            }
            if (!token.startsWith("stale")) continue;
            stale = HTTPDigestUtil.extract(token, "stale=");
        }
        Digest digestHolder = new Digest();
        digestHolder.setUsername(username).setRealm(realm).setNonce(nonce).setUri(uri).setQop(qop).setNonceCount(nc).setClientNonce(cnonce).setDigest(clientResponse).setOpaque(opaque);
        digestHolder.setStale(stale).setDomain(domain);
        return digestHolder;
    }

    public static byte[] md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5_ALGORITHM);
            return md.digest(str.getBytes(UTF8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String clientResponseValue(Digest digest, char[] password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MD5_ALGORITHM);
            messageDigest.update(digest.getUsername().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getRealm().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(new String(password).getBytes(UTF8));
            byte[] ha1 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(digest.getMethod().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getUri().getBytes(UTF8));
            byte[] ha2 = messageDigest.digest();
            messageDigest.update(HTTPDigestUtil.convertBytesToHex(ha1).getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonceCount().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getClientNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getQop().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(HTTPDigestUtil.convertBytesToHex(ha2).getBytes(UTF8));
            byte[] digestedValue = messageDigest.digest();
            return HTTPDigestUtil.convertBytesToHex(digestedValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchCredential(Digest digest, char[] password) {
        return HTTPDigestUtil.clientResponseValue(digest, password).equalsIgnoreCase(digest.getDigest());
    }

    public static String convertBytesToHex(byte[] bytes) {
        int base = 16;
        int ALL_ON = 255;
        StringBuilder buf = new StringBuilder();
        for (byte byteValue : bytes) {
            int bit = ALL_ON & byteValue;
            int c = 48 + bit / base % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bit % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
        }
        return buf.toString();
    }
}

