/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.interception.ClientReaderInterceptorContext;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.AbstractBuiltResponse;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public class BuiltResponse
extends AbstractBuiltResponse {
    public BuiltResponse() {
    }

    public BuiltResponse(int status, Headers<Object> metadata, Object entity, Annotation[] entityAnnotations) {
        this(status, null, metadata, entity, entityAnnotations);
    }

    public BuiltResponse(int status, String reason, Headers<Object> metadata, Object entity, Annotation[] entityAnnotations) {
        super(status, reason, metadata, entity, entityAnnotations);
    }

    @Override
    public <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
        block14: {
            this.abortIfClosed();
            if (this.entity != null) {
                if (type.isInstance(this.entity)) {
                    return (T)this.entity;
                }
                if (this.entity instanceof InputStream) {
                    this.setInputStream((InputStream)this.entity);
                    this.entity = null;
                } else {
                    if (this.bufferedEntity == null) {
                        throw new RuntimeException(Messages.MESSAGES.entityAlreadyRead(this.entity.getClass()));
                    }
                    this.entity = null;
                }
            }
            if (this.entity == null) {
                if (this.status == 204) {
                    return null;
                }
                try {
                    this.entity = this.readFrom(type, genericType, this.getMediaType(), anns);
                    if (this.entity != null && (this.entity == null || InputStream.class.isInstance(this.entity) || Reader.class.isInstance(this.entity) || this.bufferedEntity != null)) break block14;
                    try {
                        if (!EventInput.class.isInstance(this.entity)) {
                            this.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (RuntimeException e) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LogMessages.LOGGER.clientSideProcessingFailure(e);
                    throw e;
                }
            }
        }
        return (T)this.entity;
    }

    protected synchronized <T> Object readFrom(Class<T> type, Type genericType, MediaType media, Annotation[] annotations) {
        Type useGeneric = genericType == null ? type : genericType;
        Class<Object> useType = type;
        media = media == null ? MediaType.WILDCARD_TYPE : media;
        annotations = annotations == null ? this.annotations : annotations;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        try {
            InputStream is = this.getEntityStream();
            if (is == null) {
                throw new IllegalStateException(Messages.MESSAGES.inputStreamWasEmpty());
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
            ReaderInterceptor[] readerInterceptors = (ReaderInterceptor[])providerFactory.getServerReaderInterceptorRegistry().postMatch(null, null);
            ClientReaderInterceptorContext context = new ClientReaderInterceptorContext(readerInterceptors, providerFactory, useType, useGeneric, annotations, media, this.getStringHeaders(), is, new HashMap<String, Object>());
            final Object finalObj = context.proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                return new MarshalledEntity<Object>(){

                    @Override
                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    @Override
                    public Object getEntity() {
                        return finalObj;
                    }
                };
            }
            return finalObj;
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
    }

    @Override
    protected InputStream getEntityStream() {
        if (this.bufferedEntity != null) {
            return new ByteArrayInputStream(this.bufferedEntity);
        }
        if (this.isClosed()) {
            throw new ProcessingException(Messages.MESSAGES.streamIsClosed());
        }
        InputStream is = this.getInputStream();
        return is != null ? new AbstractBuiltResponse.InputStreamWrapper<BuiltResponse>(is, this) : null;
    }

    @Override
    protected void setInputStream(InputStream is) {
        this.is = is;
        this.resetEntity();
    }

    @Override
    protected InputStream getInputStream() {
        if (this.is == null && this.entity != null && this.entity instanceof InputStream) {
            this.is = (InputStream)this.entity;
        }
        return this.is;
    }

    @Override
    public void releaseConnection() throws IOException {
        this.releaseConnection(false);
    }

    @Override
    public void releaseConnection(boolean consumeInputStream) throws IOException {
        try {
            if (this.is != null) {
                if (consumeInputStream) {
                    while (this.is.read() > 0) {
                    }
                }
                this.is.close();
                this.is = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean bufferEntity() {
        this.abortIfClosed();
        if (this.bufferedEntity != null) {
            return true;
        }
        if (this.streamRead) {
            return false;
        }
        InputStream is = this.getInputStream();
        if (is == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream(1024, is);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                this.releaseConnection();
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        return true;
    }
}

