/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.TypedProperties;

public class ConfigurationProperties {
    private static final String ICH = "infinispan.client.hotrod.";
    @Deprecated
    public static final String TRANSPORT_FACTORY = "infinispan.client.hotrod.transport_factory";
    public static final String SERVER_LIST = "infinispan.client.hotrod.server_list";
    public static final String MARSHALLER = "infinispan.client.hotrod.marshaller";
    public static final String ASYNC_EXECUTOR_FACTORY = "infinispan.client.hotrod.async_executor_factory";
    public static final String CLIENT_INTELLIGENCE = "infinispan.client.hotrod.client_intelligence";
    public static final String DEFAULT_EXECUTOR_FACTORY_POOL_SIZE = "infinispan.client.hotrod.default_executor_factory.pool_size";
    public static final String DEFAULT_EXECUTOR_FACTORY_THREADNAME_PREFIX = "infinispan.client.hotrod.default_executor_factory.threadname_prefix";
    public static final String DEFAULT_EXECUTOR_FACTORY_THREADNAME_SUFFIX = "infinispan.client.hotrod.default_executor_factory.threadname_suffix";
    public static final String TCP_NO_DELAY = "infinispan.client.hotrod.tcp_no_delay";
    public static final String TCP_KEEP_ALIVE = "infinispan.client.hotrod.tcp_keep_alive";
    @Deprecated
    public static final String PING_ON_STARTUP = "infinispan.client.hotrod.ping_on_startup";
    public static final String REQUEST_BALANCING_STRATEGY = "infinispan.client.hotrod.request_balancing_strategy";
    public static final String KEY_SIZE_ESTIMATE = "infinispan.client.hotrod.key_size_estimate";
    public static final String VALUE_SIZE_ESTIMATE = "infinispan.client.hotrod.value_size_estimate";
    public static final String FORCE_RETURN_VALUES = "infinispan.client.hotrod.force_return_values";
    public static final String HASH_FUNCTION_PREFIX = "infinispan.client.hotrod.hash_function_impl";
    @Deprecated
    public static final String DEFAULT_EXECUTOR_FACTORY_QUEUE_SIZE = "infinispan.client.hotrod.default_executor_factory.queue_size";
    public static final String SO_TIMEOUT = "infinispan.client.hotrod.socket_timeout";
    public static final String CONNECT_TIMEOUT = "infinispan.client.hotrod.connect_timeout";
    public static final String PROTOCOL_VERSION = "infinispan.client.hotrod.protocol_version";
    public static final String USE_SSL = "infinispan.client.hotrod.use_ssl";
    public static final String KEY_STORE_FILE_NAME = "infinispan.client.hotrod.key_store_file_name";
    public static final String KEY_STORE_TYPE = "infinispan.client.hotrod.key_store_type";
    public static final String KEY_STORE_PASSWORD = "infinispan.client.hotrod.key_store_password";
    public static final String SNI_HOST_NAME = "infinispan.client.hotrod.sni_host_name";
    public static final String KEY_ALIAS = "infinispan.client.hotrod.key_alias";
    public static final String KEY_STORE_CERTIFICATE_PASSWORD = "infinispan.client.hotrod.key_store_certificate_password";
    public static final String TRUST_STORE_FILE_NAME = "infinispan.client.hotrod.trust_store_file_name";
    public static final String TRUST_STORE_PATH = "infinispan.client.hotrod.trust_store_path";
    public static final String TRUST_STORE_TYPE = "infinispan.client.hotrod.trust_store_type";
    public static final String TRUST_STORE_PASSWORD = "infinispan.client.hotrod.trust_store_password";
    public static final String SSL_PROTOCOL = "infinispan.client.hotrod.ssl_protocol";
    public static final String SSL_CONTEXT = "infinispan.client.hotrod.ssl_context";
    public static final String MAX_RETRIES = "infinispan.client.hotrod.max_retries";
    public static final String USE_AUTH = "infinispan.client.hotrod.use_auth";
    public static final String SASL_MECHANISM = "infinispan.client.hotrod.sasl_mechanism";
    public static final String AUTH_CALLBACK_HANDLER = "infinispan.client.hotrod.auth_callback_handler";
    public static final String AUTH_SERVER_NAME = "infinispan.client.hotrod.auth_server_name";
    public static final String AUTH_USERNAME = "infinispan.client.hotrod.auth_username";
    public static final String AUTH_PASSWORD = "infinispan.client.hotrod.auth_password";
    public static final String AUTH_REALM = "infinispan.client.hotrod.auth_realm";
    public static final String AUTH_CLIENT_SUBJECT = "infinispan.client.hotrod.auth_client_subject";
    public static final String SASL_PROPERTIES_PREFIX = "infinispan.client.hotrod.sasl_properties";
    public static final Pattern SASL_PROPERTIES_PREFIX_REGEX = Pattern.compile("^infinispan.client.hotrod.sasl_properties.");
    public static final String JAVA_SERIAL_WHITELIST = "infinispan.client.hotrod.java_serial_whitelist";
    public static final String BATCH_SIZE = "infinispan.client.hotrod.batch_size";
    public static final String STATISTICS = "infinispan.client.hotrod.statistics";
    public static final String JMX = "infinispan.client.hotrod.jmx";
    public static final String JMX_NAME = "infinispan.client.hotrod.jmx_name";
    public static final String JMX_DOMAIN = "infinispan.client.hotrod.jmx_domain";
    public static final String TRANSACTION_MANAGER_LOOKUP = "infinispan.client.hotrod.transaction.transaction_manager_lookup";
    public static final String TRANSACTION_MODE = "infinispan.client.hotrod.transaction.transaction_mode";
    public static final String TRANSACTION_TIMEOUT = "infinispan.client.hotrod.transaction.timeout";
    public static final String NEAR_CACHE_MAX_ENTRIES = "infinispan.client.hotrod.near_cache.max_entries";
    public static final String NEAR_CACHE_MODE = "infinispan.client.hotrod.near_cache.mode";
    public static final String NEAR_CACHE_NAME_PATTERN = "infinispan.client.hotrod.near_cache.name_pattern";
    public static final String CONNECTION_POOL_MAX_ACTIVE = "infinispan.client.hotrod.connection_pool.max_active";
    public static final String CONNECTION_POOL_MAX_WAIT = "infinispan.client.hotrod.connection_pool.max_wait";
    public static final String CONNECTION_POOL_MIN_IDLE = "infinispan.client.hotrod.connection_pool.min_idle";
    public static final String CONNECTION_POOL_MAX_PENDING_REQUESTS = "infinispan.client.hotrod.connection_pool.max_pending_requests";
    public static final String CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME = "infinispan.client.hotrod.connection_pool.min_evictable_idle_time";
    public static final String CONNECTION_POOL_EXHAUSTED_ACTION = "infinispan.client.hotrod.connection_pool.exhausted_action";
    public static final String CLUSTER_PROPERTIES_PREFIX = "infinispan.client.hotrod.cluster";
    public static final Pattern CLUSTER_PROPERTIES_PREFIX_REGEX = Pattern.compile("^infinispan.client.hotrod.cluster.");
    public static final int DEFAULT_KEY_SIZE = 64;
    public static final int DEFAULT_VALUE_SIZE = 512;
    public static final int DEFAULT_HOTROD_PORT = 11222;
    public static final int DEFAULT_SO_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final int DEFAULT_BATCH_SIZE = 10000;
    private final TypedProperties props;

    public ConfigurationProperties() {
        this.props = new TypedProperties();
    }

    public ConfigurationProperties(String serverList) {
        this();
        this.setServerList(serverList);
    }

    public ConfigurationProperties(Properties props) {
        this.props = props == null ? new TypedProperties() : TypedProperties.toTypedProperties((Properties)props);
    }

    public void setServerList(String serverList) {
        this.props.setProperty(SERVER_LIST, serverList);
    }

    public String getTransportFactory() {
        return this.props.getProperty(TRANSPORT_FACTORY, ChannelFactory.class.getName());
    }

    public String getMarshaller() {
        return this.props.getProperty(MARSHALLER, GenericJBossMarshaller.class.getName());
    }

    public void setMarshaller(String marshaller) {
        this.props.setProperty(MARSHALLER, marshaller);
    }

    public String getAsyncExecutorFactory() {
        return this.props.getProperty(ASYNC_EXECUTOR_FACTORY, DefaultAsyncExecutorFactory.class.getName());
    }

    public int getDefaultExecutorFactoryPoolSize() {
        return this.props.getIntProperty(DEFAULT_EXECUTOR_FACTORY_POOL_SIZE, 99);
    }

    public void setDefaultExecutorFactoryPoolSize(int poolSize) {
        this.props.setProperty(DEFAULT_EXECUTOR_FACTORY_POOL_SIZE, poolSize);
    }

    public String getDefaultExecutorFactoryThreadNamePrefix() {
        return this.props.getProperty(DEFAULT_EXECUTOR_FACTORY_THREADNAME_PREFIX, "HotRod-client-async-pool");
    }

    public void setDefaultExecutorFactoryThreadNamePrefix(String threadNamePrefix) {
        this.props.setProperty(DEFAULT_EXECUTOR_FACTORY_THREADNAME_PREFIX, threadNamePrefix);
    }

    public String getDefaultExecutorFactoryThreadNameSuffix() {
        return this.props.getProperty(DEFAULT_EXECUTOR_FACTORY_THREADNAME_SUFFIX, "");
    }

    public void setDefaultExecutorFactoryThreadNameSuffix(String threadNameSuffix) {
        this.props.setProperty(DEFAULT_EXECUTOR_FACTORY_THREADNAME_SUFFIX, threadNameSuffix);
    }

    public boolean getTcpNoDelay() {
        return this.props.getBooleanProperty(TCP_NO_DELAY, true);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.props.setProperty(TCP_NO_DELAY, tcpNoDelay);
    }

    public boolean getTcpKeepAlive() {
        return this.props.getBooleanProperty(TCP_KEEP_ALIVE, false);
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.props.setProperty(TCP_KEEP_ALIVE, tcpKeepAlive);
    }

    public String getRequestBalancingStrategy() {
        return this.props.getProperty(REQUEST_BALANCING_STRATEGY, RoundRobinBalancingStrategy.class.getName());
    }

    public int getKeySizeEstimate() {
        return this.props.getIntProperty(KEY_SIZE_ESTIMATE, 64);
    }

    public void setKeySizeEstimate(int keySizeEstimate) {
        this.props.setProperty(KEY_SIZE_ESTIMATE, keySizeEstimate);
    }

    public int getValueSizeEstimate() {
        return this.props.getIntProperty(VALUE_SIZE_ESTIMATE, 512);
    }

    public void setValueSizeEstimate(int valueSizeEstimate) {
        this.props.setProperty(VALUE_SIZE_ESTIMATE, valueSizeEstimate);
    }

    public boolean getForceReturnValues() {
        return this.props.getBooleanProperty(FORCE_RETURN_VALUES, false);
    }

    public void setForceReturnValues(boolean forceReturnValues) {
        this.props.setProperty(FORCE_RETURN_VALUES, forceReturnValues);
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getSoTimeout() {
        return this.props.getIntProperty(SO_TIMEOUT, 60000);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.props.setProperty(SO_TIMEOUT, socketTimeout);
    }

    public String getProtocolVersion() {
        return this.props.getProperty(PROTOCOL_VERSION, ProtocolVersion.DEFAULT_PROTOCOL_VERSION.toString());
    }

    public void setProtocolVersion(String protocolVersion) {
        this.props.setProperty(PROTOCOL_VERSION, protocolVersion);
    }

    public String getClientIntelligence() {
        return this.props.getProperty(CLIENT_INTELLIGENCE, ClientIntelligence.getDefault().name());
    }

    public void setClientIntelligence(String clientIntelligence) {
        this.props.setProperty(CLIENT_INTELLIGENCE, clientIntelligence);
    }

    public int getConnectTimeout() {
        return this.props.getIntProperty(CONNECT_TIMEOUT, 60000);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.props.setProperty(CONNECT_TIMEOUT, connectTimeout);
    }

    public boolean getUseSSL() {
        return this.props.getBooleanProperty(USE_SSL, false);
    }

    public void setUseSSL(boolean useSSL) {
        this.props.setProperty(USE_SSL, useSSL);
    }

    public String getKeyStoreFileName() {
        return this.props.getProperty(KEY_STORE_FILE_NAME);
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.props.setProperty(KEY_STORE_FILE_NAME, keyStoreFileName);
    }

    public String getKeyStoreType() {
        return this.props.getProperty(KEY_STORE_TYPE);
    }

    public void setKeyStoreType(String keyStoreType) {
        this.props.setProperty(KEY_STORE_TYPE, keyStoreType);
    }

    public String getKeyStorePassword() {
        return this.props.getProperty(KEY_STORE_PASSWORD);
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.props.setProperty(KEY_STORE_PASSWORD, keyStorePassword);
    }

    public void setKeyStoreCertificatePassword(String keyStoreCertificatePassword) {
        this.props.setProperty(KEY_STORE_CERTIFICATE_PASSWORD, keyStoreCertificatePassword);
    }

    public String getKeyAlias() {
        return this.props.getProperty(KEY_ALIAS);
    }

    public void setKeyAlias(String keyAlias) {
        this.props.setProperty(KEY_ALIAS, keyAlias);
    }

    public String getTrustStoreFileName() {
        return this.props.getProperty(TRUST_STORE_FILE_NAME);
    }

    public void setTrustStoreFileName(String trustStoreFileName) {
        this.props.setProperty(TRUST_STORE_FILE_NAME, trustStoreFileName);
    }

    public String getTrustStoreType() {
        return this.props.getProperty(TRUST_STORE_TYPE);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.props.setProperty(TRUST_STORE_TYPE, trustStoreType);
    }

    public String getTrustStorePassword() {
        return this.props.getProperty(TRUST_STORE_PASSWORD);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.props.setProperty(TRUST_STORE_PASSWORD, trustStorePassword);
    }

    public String getTrustStorePath() {
        return this.props.getProperty(TRUST_STORE_PATH);
    }

    public void setTrustStorePath(String trustStorePath) {
        this.props.setProperty(TRUST_STORE_PATH, trustStorePath);
    }

    public String getSSLProtocol() {
        return this.props.getProperty(SSL_PROTOCOL);
    }

    public void setSSLProtocol(String sslProtocol) {
        this.props.setProperty(SSL_PROTOCOL, sslProtocol);
    }

    public String getSniHostName() {
        return this.props.getProperty(SNI_HOST_NAME);
    }

    public void setSniHostName(String sniHostName) {
        this.props.setProperty(SNI_HOST_NAME, sniHostName);
    }

    public boolean getUseAuth() {
        return this.props.getBooleanProperty(USE_AUTH, false);
    }

    public void setUseAuth(boolean useAuth) {
        this.props.setProperty(USE_AUTH, useAuth);
    }

    public String getSaslMechanism() {
        return this.props.getProperty(SASL_MECHANISM);
    }

    public void setSaslMechanism(String saslMechanism) {
        this.props.setProperty(SASL_MECHANISM, saslMechanism);
    }

    public String getAuthUsername() {
        return this.props.getProperty(AUTH_USERNAME);
    }

    public void setAuthUsername(String authUsername) {
        this.props.setProperty(AUTH_USERNAME, authUsername);
    }

    public String getAuthPassword() {
        return this.props.getProperty(AUTH_PASSWORD);
    }

    public void setAuthPassword(String authPassword) {
        this.props.setProperty(AUTH_PASSWORD, authPassword);
    }

    public String getAuthRealm() {
        return this.props.getProperty(AUTH_REALM);
    }

    public void setAuthRealm(String authRealm) {
        this.props.setProperty(AUTH_REALM, authRealm);
    }

    public void setAuthServerName(String authServerName) {
        this.props.setProperty(AUTH_SERVER_NAME, authServerName);
    }

    public int getMaxRetries() {
        return this.props.getIntProperty(MAX_RETRIES, 10);
    }

    public void setMaxRetries(int maxRetries) {
        this.props.setProperty(MAX_RETRIES, maxRetries);
    }

    public int getBatchSize() {
        return this.props.getIntProperty(BATCH_SIZE, 10000);
    }

    public void setBatchSize(int batchSize) {
        this.props.setProperty(BATCH_SIZE, batchSize);
    }

    public void setStatistics(boolean statistics) {
        this.props.setProperty(STATISTICS, statistics);
    }

    public boolean isStatistics() {
        return this.props.getBooleanProperty(STATISTICS, ((Boolean)StatisticsConfiguration.ENABLED.getDefaultValue()).booleanValue());
    }

    public void setJmx(boolean jmx) {
        this.props.setProperty(JMX, jmx);
    }

    public boolean isJmx() {
        return this.props.getBooleanProperty(JMX, ((Boolean)StatisticsConfiguration.JMX_ENABLED.getDefaultValue()).booleanValue());
    }

    public void setJmxName(String jmxName) {
        this.props.setProperty(JMX_NAME, jmxName);
    }

    public void getJmxName() {
        this.props.getProperty(JMX_NAME);
    }

    public void setJmxDomain(String jmxDomain) {
        this.props.setProperty(JMX_DOMAIN, jmxDomain);
    }

    public void getJmxDomain() {
        this.props.getProperty(JMX_DOMAIN);
    }

    public String getTransactionManagerLookup() {
        return this.props.getProperty(TRANSACTION_MANAGER_LOOKUP, TransactionConfigurationBuilder.defaultTransactionManagerLookup().getClass().getName(), true);
    }

    public void setTransactionManagerLookup(String transactionManagerLookup) {
        this.props.setProperty(TRANSACTION_MANAGER_LOOKUP, transactionManagerLookup);
    }

    public TransactionMode getTransactionMode() {
        return (TransactionMode)this.props.getEnumProperty(TRANSACTION_MODE, TransactionMode.class, (Enum)TransactionMode.NONE, true);
    }

    public void setTransactionMode(String transactionMode) {
        this.props.setProperty(TRANSACTION_MODE, transactionMode);
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.props.setProperty(TRANSACTION_TIMEOUT, transactionTimeout);
    }

    public NearCacheMode getNearCacheMode() {
        return (NearCacheMode)this.props.getEnumProperty(NEAR_CACHE_MODE, NearCacheMode.class, (Enum)NearCacheMode.DISABLED, true);
    }

    public void setNearCacheMode(String nearCacheMode) {
        this.props.setProperty(NEAR_CACHE_MODE, nearCacheMode);
    }

    public int getNearCacheMaxEntries() {
        return this.props.getIntProperty(NEAR_CACHE_MAX_ENTRIES, -1);
    }

    public void setNearCacheMaxEntries(int nearCacheMaxEntries) {
        this.props.setProperty(NEAR_CACHE_MAX_ENTRIES, nearCacheMaxEntries);
    }

    public String getNearCacheNamePattern() {
        return this.props.getProperty(NEAR_CACHE_NAME_PATTERN);
    }

    public void setNearCacheNamePattern(String nearCacheNamePattern) {
        this.props.setProperty(NEAR_CACHE_NAME_PATTERN, nearCacheNamePattern);
    }

    public int getConnectionPoolMaxActive() {
        return this.props.getIntProperty(CONNECTION_POOL_MAX_ACTIVE, -1);
    }

    public void setConnectionPoolMaxActive(int connectionPoolMaxActive) {
        this.props.setProperty(CONNECTION_POOL_MAX_ACTIVE, connectionPoolMaxActive);
    }

    public long getConnectionPoolMaxWait() {
        return this.props.getLongProperty(CONNECTION_POOL_MAX_WAIT, -1L);
    }

    public void setConnectionPoolMaxWait(long connectionPoolMaxWait) {
        this.props.setProperty(CONNECTION_POOL_MAX_WAIT, connectionPoolMaxWait);
    }

    public int gtConnectionPoolMinIdle() {
        return this.props.getIntProperty(CONNECTION_POOL_MIN_IDLE, -1);
    }

    public void setConnectionPoolMinIdle(int connectionPoolMinIdle) {
        this.props.setProperty(CONNECTION_POOL_MIN_IDLE, connectionPoolMinIdle);
    }

    public int getConnectionPoolMaxPendingRequests() {
        return this.props.getIntProperty(CONNECTION_POOL_MAX_PENDING_REQUESTS, 5);
    }

    public void setConnectionPoolMaxPendingRequests(int connectionPoolMaxPendingRequests) {
        this.props.setProperty(CONNECTION_POOL_MAX_PENDING_REQUESTS, connectionPoolMaxPendingRequests);
    }

    public long setConnectionPoolMinEvictableIdleTime() {
        return this.props.getLongProperty(CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME, 1800000L);
    }

    public void setConnectionPoolMinEvictableIdleTime(long connectionPoolMinEvictableIdleTime) {
        this.props.setProperty(CONNECTION_POOL_MIN_EVICTABLE_IDLE_TIME, connectionPoolMinEvictableIdleTime);
    }

    public ExhaustedAction getConnectionPoolExhaustedAction() {
        return (ExhaustedAction)this.props.getEnumProperty(CONNECTION_POOL_EXHAUSTED_ACTION, ExhaustedAction.class, (Enum)ExhaustedAction.WAIT);
    }

    public void setConnectionPoolExhaustedAction(String connectionPoolExhaustedAction) {
        this.props.setProperty(CONNECTION_POOL_EXHAUSTED_ACTION, connectionPoolExhaustedAction);
    }

    public static boolean isVersionPre12(Configuration cfg) {
        String version = cfg.version().toString();
        return Objects.equals(version, "1.0") || Objects.equals(version, "1.1");
    }

    public long getTransactionTimeout() {
        return this.props.getLongProperty(TRANSACTION_TIMEOUT, 60000L);
    }

    public String getServerList() {
        return this.props.getProperty(SERVER_LIST);
    }

    public void setJavaSerialWhitelist(String javaSerialWhitelist) {
        this.props.setProperty(JAVA_SERIAL_WHITELIST, javaSerialWhitelist);
    }
}

