/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.x500.GeneralName;

final class EntitySaslServer
extends AbstractSaslServer {
    private static final int ST_CHALLENGE = 1;
    private static final int ST_PROCESS_RESPONSE = 2;
    private final SecureRandom secureRandom;
    private final Signature signature;
    private final boolean mutual;
    private final String serverName;
    private String authorizationID;
    private byte[] randomB;

    EntitySaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, boolean mutual, Signature signature, SecureRandom secureRandom) {
        super(mechanismName, protocol, serverName, callbackHandler, ElytronMessages.saslEntity);
        this.signature = signature;
        this.secureRandom = secureRandom;
        this.mutual = mutual;
        this.serverName = serverName;
    }

    public void init() {
        this.setNegotiationState(1);
    }

    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.saslEntity.mechAuthenticationNotComplete();
        }
        return this.authorizationID;
    }

    /*
     * Unable to fully structure code
     */
    protected byte[] evaluateMessage(int state, byte[] response) throws SaslException {
        switch (state) {
            case 1: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.saslEntity.mechInitialChallengeMustBeEmpty().toSaslException();
                }
                encoder = new DEREncoder();
                try {
                    encoder.startSequence();
                    this.randomB = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    if (this.serverName != null && !this.serverName.isEmpty()) {
                        encoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(encoder, (GeneralName)new GeneralName.DNSName(this.serverName));
                    }
                    trustedAuthoritiesCallback = new TrustedAuthoritiesCallback();
                    this.handleCallbacks(new Callback[]{trustedAuthoritiesCallback});
                    trustedAuthorities = trustedAuthoritiesCallback.getTrustedAuthorities();
                    if (trustedAuthorities != null && !trustedAuthorities.isEmpty()) {
                        encoder.encodeImplicit(1);
                        EntityUtil.encodeTrustedAuthorities(encoder, trustedAuthorities);
                    }
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.saslEntity.mechUnableToCreateResponseTokenWithCause((Throwable)e).toSaslException();
                }
                this.setNegotiationState(2);
                return encoder.getEncoded();
            }
            case 2: {
                decoder = new DERDecoder(response);
                serverCertChain = null;
                serverCert = null;
                privateKey = null;
                entityB = null;
                authID = null;
                try {
                    decoder.startSequence();
                    randomA = decoder.decodeOctetString();
                    if (decoder.isNextType(128, 0, true)) {
                        decoder.decodeImplicit(0);
                        entityB = EntityUtil.decodeGeneralNames(decoder);
                    }
                    decoder.startExplicit(1);
                    evidence = new X509PeerCertificateChainEvidence(EntityUtil.decodeCertificateData(decoder));
                    decoder.endExplicit();
                    clientCert = evidence.getFirstCertificate();
                    evidenceVerifyCallback = new EvidenceVerifyCallback((Evidence)evidence);
                    this.handleCallbacks(new Callback[]{evidenceVerifyCallback});
                    if (!evidenceVerifyCallback.isVerified()) {
                        throw ElytronMessages.saslEntity.mechAuthenticationFailed().toSaslException();
                    }
                    clientName = evidence.getPrincipal().getName("CANONICAL");
                    if (decoder.isNextType(128, 2, true)) {
                        decoder.decodeImplicit(2);
                        authID = EntityUtil.decodeGeneralNames(decoder);
                        this.authorizationID = EntityUtil.getDistinguishedNameFromGeneralNames(authID);
                    } else {
                        this.authorizationID = clientName;
                    }
                    decoder.startSequence();
                    decoder.skipElement();
                    clientSignature = decoder.decodeBitString();
                    decoder.endSequence();
                    tbsEncoder = new DEREncoder();
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(this.randomB);
                    if (entityB != null) {
                        tbsEncoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(tbsEncoder, entityB);
                    }
                    if (authID != null) {
                        tbsEncoder.encodeImplicit(1);
                        EntityUtil.encodeGeneralNames(tbsEncoder, authID);
                    }
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initVerify(clientCert);
                        this.signature.update(tbsEncoder.getEncoded());
                        if (!this.signature.verify(clientSignature)) {
                            this.setNegotiationState(-1);
                            throw ElytronMessages.saslEntity.mechAuthenticationFailed().toSaslException();
                        }
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.saslEntity.mechUnableToVerifyClientSignature((Throwable)e).toSaslException();
                    }
                    decoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.saslEntity.mechInvalidClientMessageWithCause((Throwable)e).toSaslException();
                }
                if (entityB != null || this.mutual) {
                    credentialCallback = new ServerCredentialCallback(X509CertificateChainPrivateCredential.class, Entity.keyType(this.signature.getAlgorithm()));
                    try {
                        this.tryHandleCallbacks(new Callback[]{credentialCallback});
                        serverCertChainPrivateCredential = (X509CertificateChainPrivateCredential)credentialCallback.getCredential(X509CertificateChainPrivateCredential.class);
                        if (serverCertChainPrivateCredential != null) {
                            serverCertChain = serverCertChainPrivateCredential.getCertificateChain();
                            if (serverCertChain == null || serverCertChain.length <= 0) {
                                throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedServerCertificate().toSaslException();
                            }
                            serverCert = serverCertChain[0];
                        } else {
                            throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedServerCertificate().toSaslException();
                        }
                        privateKey = serverCertChainPrivateCredential.getPrivateKey();
                    }
                    catch (UnsupportedCallbackException e) {
                        throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedServerCertificate().toSaslException();
                    }
                }
                if (entityB != null && !EntityUtil.matchGeneralNames(entityB, serverCert)) {
                    throw ElytronMessages.saslEntity.mechServerIdentifierMismatch().toSaslException();
                }
                authorizeCallback = new AuthorizeCallback(clientName, this.authorizationID);
                this.handleCallbacks(new Callback[]{authorizeCallback});
                if (!authorizeCallback.isAuthorized()) {
                    throw ElytronMessages.saslEntity.mechAuthorizationFailed(clientName, this.authorizationID).toSaslException();
                }
                if (!this.mutual) ** GOTO lbl147
                encoder = new DEREncoder();
                try {
                    encoder.startSequence();
                    randomC = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    clientSubjectAltNames = null;
                    try {
                        clientSubjectAltNames = clientCert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException e) {
                        if (!clientName.isEmpty()) ** GOTO lbl114
                        throw ElytronMessages.saslEntity.mechUnableToDetermineClientName((Throwable)e).toSaslException();
                    }
lbl114:
                    // 2 sources

                    encoder.encodeImplicit(0);
                    EntityUtil.encodeGeneralNames(encoder, clientName, clientSubjectAltNames);
                    encoder.startExplicit(1);
                    if (serverCertChain == null || serverCertChain.length == 0) {
                        throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedServerCertificate().toSaslException();
                    }
                    EntityUtil.encodeX509CertificateChain(encoder, serverCertChain);
                    encoder.endExplicit();
                    if (privateKey == null) {
                        throw ElytronMessages.saslEntity.mechCallbackHandlerNotProvidedPrivateKey().toSaslException();
                    }
                    tbsEncoder = new DEREncoder();
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(this.randomB);
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(randomC);
                    EntityUtil.encodeGeneralNames(tbsEncoder, clientName, clientSubjectAltNames);
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initSign(privateKey);
                        this.signature.update(tbsEncoder.getEncoded());
                        signatureBytes = this.signature.sign();
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.saslEntity.mechUnableToCreateSignature((Throwable)e).toSaslException();
                    }
                    encoder.startSequence();
                    EntityUtil.encodeAlgorithmIdentifier(encoder, this.signature.getAlgorithm());
                    encoder.encodeBitString(signatureBytes);
                    encoder.endSequence();
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.saslEntity.mechUnableToCreateResponseTokenWithCause((Throwable)e).toSaslException();
                }
                this.negotiationComplete();
                return encoder.getEncoded();
lbl147:
                // 1 sources

                this.negotiationComplete();
                return null;
            }
            case 0: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.saslEntity.mechClientSentExtraMessage().toSaslException();
                }
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

