/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;

public class ConnectionAbstract
extends InputAbstract {
    @Option(name={"--url"}, description="URL towards the broker. (default: tcp://localhost:61616)")
    protected String brokerURL = "tcp://localhost:61616";
    @Option(name={"--user"}, description="User used to connect")
    protected String user;
    @Option(name={"--password"}, description="Password used to connect")
    protected String password;
    @Option(name={"--clientID"}, description="ClientID to be associated with connection")
    String clientID;
    @Option(name={"--protocol"}, description="Protocol used. Valid values are amqp or core. Default=core.")
    String protocol = "core";

    protected ConnectionFactory createConnectionFactory() throws Exception {
        if (this.protocol.equals("core")) {
            return this.createCoreConnectionFactory();
        }
        if (this.protocol.equals("amqp")) {
            return this.createAMQPConnectionFactory();
        }
        throw new IllegalStateException("protocol " + this.protocol + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory() {
        if (this.brokerURL.startsWith("tcp://")) {
            this.brokerURL = "amqp" + this.brokerURL.substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(this.user, this.password, this.brokerURL);
        if (this.clientID != null) {
            cf.setClientID(this.clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.userPassword();
            return new JmsConnectionFactory(this.user, this.password, this.brokerURL);
        }
        catch (JMSException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", this.brokerURL);
            this.userPassword();
            return new JmsConnectionFactory(this.user, this.password, this.brokerURL);
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory() {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
        if (this.clientID != null) {
            System.out.println("Consumer:: clientID = " + this.clientID);
            cf.setClientID(this.clientID);
        }
        try {
            Connection connection = cf.createConnection();
            connection.close();
            return cf;
        }
        catch (JMSSecurityException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.userPassword();
            return new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
        }
        catch (JMSException e) {
            this.context.err.println("Connection failed::" + e.getMessage());
            this.brokerURL = this.input("--url", "Type in the broker URL for a retry (e.g. tcp://localhost:61616)", this.brokerURL);
            this.userPassword();
            return new ActiveMQConnectionFactory(this.brokerURL, this.user, this.password);
        }
    }

    private void userPassword() {
        if (this.user == null) {
            this.user = this.input("--user", "Type the username for a retry", null);
        }
        if (this.password == null) {
            this.password = this.inputPassword("--password", "Type the password for a retry", null);
        }
    }
}

