/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Function;
import org.jboss.as.clustering.controller.AbstractCapabilityReference;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class CapabilityReference
extends AbstractCapabilityReference {
    private final Function<OperationContext, String> parentNameResolver;
    private final String parentSegment;

    public CapabilityReference(Capability capability, UnaryRequirement requirement) {
        super(capability, (Requirement)requirement);
        this.parentNameResolver = null;
        this.parentSegment = null;
    }

    public CapabilityReference(Capability capability, BinaryRequirement requirement, PathElement path) {
        this(capability, requirement, OperationContext::getCurrentAddressValue, path.getKey());
    }

    public CapabilityReference(Capability capability, BinaryRequirement requirement, Attribute parentAttribute) {
        this(capability, requirement, context -> context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel().get(parentAttribute.getName()).asString(), parentAttribute.getName());
    }

    private CapabilityReference(Capability capability, BinaryRequirement requirement, Function<OperationContext, String> parentNameResolver, String parentSegment) {
        super(capability, (Requirement)requirement);
        this.parentNameResolver = parentNameResolver;
        this.parentSegment = parentSegment;
    }

    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        String dependentName = this.getDependentName(context);
        for (String value : values) {
            if (value == null) continue;
            context.registerAdditionalCapabilityRequirement(this.getRequirementName(context, value), dependentName, attributeName);
        }
    }

    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        String dependentName = this.getDependentName(context);
        for (String value : values) {
            if (value == null) continue;
            context.deregisterCapabilityRequirement(this.getRequirementName(context, value), dependentName);
        }
    }

    private String getRequirementName(OperationContext context, String value) {
        String[] stringArray;
        if (this.parentNameResolver != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.parentNameResolver.apply(context);
            stringArray = stringArray2;
            stringArray2[1] = value;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = value;
        }
        String[] parts = stringArray;
        return RuntimeCapability.buildDynamicCapabilityName((String)this.getBaseRequirementName(), (String[])parts);
    }

    public String[] getRequirementPatternSegments(String name, PathAddress address) {
        String[] stringArray;
        if (this.parentSegment != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.parentSegment;
            stringArray = stringArray2;
            stringArray2[1] = name;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = name;
        }
        return stringArray;
    }
}

