/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import java.security.AccessController;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementConfiguration;
import org.wildfly.clustering.web.container.SecurityDomainSingleSignOnManagementProvider;
import org.wildfly.elytron.web.undertow.server.servlet.AuthenticationManager;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnManagerServiceNameProvider;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceConfigurator;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceNameProvider;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.security.jacc.JACCAuthorizationManager;
import org.wildfly.extension.undertow.sso.elytron.NonDistributableSingleSignOnManagementProvider;
import org.wildfly.extension.undertow.sso.elytron.SingleSignOnIdentifierFactory;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.ServerMechanismFactoryImpl;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.sso.SingleSignOnServerMechanismFactory;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationSecurityDomainDefinition
extends PersistentResourceDefinition {
    private static Predicate<String> SERVLET_MECHANISM;
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY;
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY;
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY;
    static final SimpleAttributeDefinition OVERRIDE_DEPLOYMENT_CONFIG;
    static final SimpleAttributeDefinition SECURITY_DOMAIN;
    private static final StringListAttributeDefinition REFERENCING_DEPLOYMENTS;
    static final SimpleAttributeDefinition ENABLE_JACC;
    static final SimpleAttributeDefinition ENABLE_JASPI;
    static final SimpleAttributeDefinition INTEGRATED_JASPI;
    private static final AttributeDefinition[] ATTRIBUTES;
    static final ApplicationSecurityDomainDefinition INSTANCE;
    private static final Set<String> knownApplicationSecurityDomains;
    private static final OperationContext.AttachmentKey<KnownDeploymentsApi> KNOWN_DEPLOYMENTS_KEY;

    private ApplicationSecurityDomainDefinition() {
        this((PersistentResourceDefinition.Parameters)new PersistentResourceDefinition.Parameters(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN, (ResourceDescriptionResolver)UndertowExtension.getResolver("application-security-domain")).setCapabilities(new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "application-security-domain", false, false, false)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("undertow", "application-security-domain"))}), new AddHandler());
    }

    private ApplicationSecurityDomainDefinition(PersistentResourceDefinition.Parameters parameters, AbstractAddStepHandler add) {
        super(parameters.setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new RemoveHandler(add)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        knownApplicationSecurityDomains.clear();
        super.registerAttributes(resourceRegistration);
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)REFERENCING_DEPLOYMENTS, (OperationStepHandler)new ReferencingDeploymentsHandler());
        }
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.singletonList(new ApplicationSecurityDomainSingleSignOnDefinition());
    }

    private static Function<String, HttpAuthenticationFactory> toHttpAuthenticationFactoryFunction(Supplier<SecurityDomain> securityDomainSupplier) {
        FilterServerMechanismFactory mechanismFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new ServerMechanismFactoryImpl(), SERVLET_MECHANISM);
        return arg_0 -> ApplicationSecurityDomainDefinition.lambda$toHttpAuthenticationFactoryFunction$0((HttpServerAuthenticationMechanismFactory)mechanismFactory, securityDomainSupplier, arg_0);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    Predicate<String> getKnownSecurityDomainPredicate() {
        return knownApplicationSecurityDomains::contains;
    }

    private static /* synthetic */ HttpAuthenticationFactory lambda$toHttpAuthenticationFactoryFunction$0(HttpServerAuthenticationMechanismFactory mechanismFactory, Supplier securityDomainSupplier, String realmName) {
        return HttpAuthenticationFactory.builder().setFactory(mechanismFactory).setSecurityDomain((SecurityDomain)securityDomainSupplier.get()).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)(realmName == null ? MechanismConfiguration.EMPTY : MechanismConfiguration.builder().addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName(realmName).build()).build()))).build();
    }

    static {
        HashSet<String> defaultMechanisms = new HashSet<String>(4);
        defaultMechanisms.add("BASIC");
        defaultMechanisms.add("CLIENT_CERT");
        defaultMechanisms.add("DIGEST");
        defaultMechanisms.add("FORM");
        SERVLET_MECHANISM = defaultMechanisms::contains;
        APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain", (boolean)true, BiFunction.class).build();
        APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain.known-deployments", (boolean)true).build();
        HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-authentication-factory")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF})).setAlternatives(new String[]{"security-domain"})).build();
        OVERRIDE_DEPLOYMENT_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("override-deployment-config", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setRestartAllServices()).setRequires(new String[]{"http-authentication-factory"})).build();
        SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.security-domain")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).setAlternatives(new String[]{"http-authentication-factory"})).build();
        REFERENCING_DEPLOYMENTS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("referencing-deployments").setStorageRuntime()).build();
        ENABLE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jacc", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
        ENABLE_JASPI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jaspi", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setRestartAllServices()).build();
        INTEGRATED_JASPI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("integrated-jaspi", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).setRestartAllServices()).build();
        ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN, HTTP_AUTHENTICATION_FACTORY, OVERRIDE_DEPLOYMENT_CONFIG, ENABLE_JACC, ENABLE_JASPI, INTEGRATED_JASPI};
        INSTANCE = new ApplicationSecurityDomainDefinition();
        knownApplicationSecurityDomains = Collections.synchronizedSet(new HashSet());
        KNOWN_DEPLOYMENTS_KEY = OperationContext.AttachmentKey.create(KnownDeploymentsApi.class);
    }

    private static class KnownDeploymentsApi {
        private volatile ApplicationSecurityDomainService service;

        private KnownDeploymentsApi() {
        }

        List<String> getKnownDeployments() {
            return this.service != null ? this.service.getDeployments() : Collections.emptyList();
        }

        void setApplicationSecurityDomainService(ApplicationSecurityDomainService service) {
            this.service = service;
        }
    }

    public static interface Registration {
        public void cancel();
    }

    private static class ApplicationSecurityDomainService
    implements Service,
    BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration> {
        private final Function<String, HttpAuthenticationFactory> factoryFunction;
        private final Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier;
        private final Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> valueConsumer;
        private final boolean overrideDeploymentConfig;
        private final Set<RegistrationImpl> registrations = new HashSet<RegistrationImpl>();
        private final boolean enableJacc;
        private final boolean enableJaspi;
        private final boolean integratedJaspi;

        private ApplicationSecurityDomainService(boolean overrideDeploymentConfig, boolean enableJacc, boolean enableJaspi, boolean integratedJaspi, Function<String, HttpAuthenticationFactory> factoryFunction, Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier, Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> valueConsumer) {
            this.overrideDeploymentConfig = overrideDeploymentConfig;
            this.enableJacc = enableJacc;
            this.enableJaspi = enableJaspi;
            this.integratedJaspi = integratedJaspi;
            this.factoryFunction = factoryFunction;
            this.singleSignOnTransformerSupplier = singleSignOnTransformerSupplier;
            this.valueConsumer = valueConsumer;
        }

        public void start(StartContext context) throws StartException {
            this.valueConsumer.accept(this);
        }

        public void stop(StopContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Registration apply(DeploymentInfo deploymentInfo, Function<String, RunAsIdentityMetaData> runAsMapper) {
            AuthenticationManager.Builder builder = AuthenticationManager.builder().setHttpAuthenticationFactory(this.factoryFunction.apply(this.getRealmName(deploymentInfo))).setOverrideDeploymentConfig(this.overrideDeploymentConfig).setHttpAuthenticationFactoryTransformer(this.singleSignOnTransformerSupplier.get()).setRunAsMapper(runAsMapper).setEnableJaspi(this.enableJaspi).setIntegratedJaspi(this.integratedJaspi);
            if (this.enableJacc) {
                builder.setAuthorizationManager(JACCAuthorizationManager.INSTANCE);
            }
            AuthenticationManager authenticationManager = builder.build();
            authenticationManager.configure(deploymentInfo);
            RegistrationImpl registration = new RegistrationImpl(deploymentInfo);
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                this.registrations.add(registration);
            }
            return registration;
        }

        private String getRealmName(DeploymentInfo deploymentInfo) {
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            return loginConfig != null ? loginConfig.getRealmName() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getDeployments() {
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                ArrayList<String> deployments = new ArrayList<String>(this.registrations.size());
                for (RegistrationImpl registration : this.registrations) {
                    deployments.add(registration.deploymentInfo.getDeploymentName());
                }
                return deployments;
            }
        }

        private class RegistrationImpl
        implements Registration {
            final DeploymentInfo deploymentInfo;

            private RegistrationImpl(DeploymentInfo deploymentInfo) {
                this.deploymentInfo = deploymentInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                if (WildFlySecurityManager.isChecking()) {
                    AccessController.doPrivileged(() -> {
                        SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                        return null;
                    });
                } else {
                    SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                }
                Set set = ApplicationSecurityDomainService.this.registrations;
                synchronized (set) {
                    ApplicationSecurityDomainService.this.registrations.remove(this);
                }
            }
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        protected RemoveHandler(AbstractAddStepHandler addOperation) {
            super(addOperation, new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY, APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY});
        }

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRemove(context, operation, model);
            knownApplicationSecurityDomains.remove(context.getCurrentAddressValue());
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
            super.performRuntime(context, operation, model);
            if (context.isResourceServiceRestartAllowed()) {
                String securityDomainName = context.getCurrentAddressValue();
                context.removeService(new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName());
                context.removeService(new SingleSignOnSessionFactoryServiceNameProvider(securityDomainName).getServiceName());
            }
        }

        protected ServiceName serviceName(String name) {
            RuntimeCapability dynamicCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(name);
            return dynamicCapability.getCapabilityServiceName(BiFunction.class);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private final SecurityDomainSingleSignOnManagementProvider provider;

        private AddHandler() {
            super(ATTRIBUTES);
            Iterator<SecurityDomainSingleSignOnManagementProvider> providers = ServiceLoader.load(SecurityDomainSingleSignOnManagementProvider.class, SecurityDomainSingleSignOnManagementProvider.class.getClassLoader()).iterator();
            this.provider = providers.hasNext() ? providers.next() : NonDistributableSingleSignOnManagementProvider.INSTANCE;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            knownApplicationSecurityDomains.add(context.getCurrentAddressValue());
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            KnownDeploymentsApi knownDeployments = new KnownDeploymentsApi();
            context.registerCapability(RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain.known-deployments", (boolean)true, (Object)knownDeployments).build().fromBaseCapability(context.getCurrentAddressValue()));
            context.attach(KNOWN_DEPLOYMENTS_KEY, (Object)knownDeployments);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            Supplier<UnaryOperator> transformerSupplier;
            Function factoryFunction;
            ModelNode model = resource.getModel();
            CapabilityServiceTarget target = context.getCapabilityServiceTarget();
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
            String httpServerMechanismFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model).asStringOrNull();
            boolean overrideDeploymentConfig = OVERRIDE_DEPLOYMENT_CONFIG.resolveModelAttribute(context, model).asBoolean();
            boolean enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            boolean enableJaspi = ENABLE_JASPI.resolveModelAttribute(context, model).asBoolean();
            boolean integratedJaspi = INTEGRATED_JASPI.resolveModelAttribute(context, model).asBoolean();
            final String securityDomainName = context.getCurrentAddressValue();
            ServiceName applicationSecurityDomainName = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
            ServiceBuilder serviceBuilder = target.addService(applicationSecurityDomainName).setInitialMode(ServiceController.Mode.LAZY);
            if (httpServerMechanismFactory != null) {
                Supplier httpAuthenticationFactorySupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, new String[]{httpServerMechanismFactory}));
                factoryFunction = arg_0 -> AddHandler.lambda$performRuntime$0((Supplier)httpAuthenticationFactorySupplier, arg_0);
            } else {
                Supplier securityDomainSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.security-domain", SecurityDomain.class, new String[]{securityDomain}));
                factoryFunction = ApplicationSecurityDomainDefinition.toHttpAuthenticationFactoryFunction(securityDomainSupplier);
            }
            if (enableJacc) {
                serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.jacc-policy", Policy.class));
            }
            if (resource.hasChild(UndertowExtension.PATH_SSO)) {
                ModelNode ssoModel = resource.getChild(UndertowExtension.PATH_SSO).getModel();
                String cookieName = SingleSignOnDefinition.Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                String domain = null;
                if (SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, ssoModel).isDefined()) {
                    domain = SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                }
                String path = SingleSignOnDefinition.Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                boolean httpOnly = SingleSignOnDefinition.Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                boolean secure = SingleSignOnDefinition.Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                SingleSignOnServerMechanismFactory.SingleSignOnConfiguration singleSignOnConfiguration = new SingleSignOnServerMechanismFactory.SingleSignOnConfiguration(cookieName, domain, path, httpOnly, secure);
                ServiceName managerServiceName = new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName();
                final SingleSignOnIdentifierFactory generator = new SingleSignOnIdentifierFactory();
                SecurityDomainSingleSignOnManagementConfiguration configuration = new SecurityDomainSingleSignOnManagementConfiguration(){

                    public String getSecurityDomainName() {
                        return securityDomainName;
                    }

                    public Supplier<String> getIdentifierGenerator() {
                        return generator;
                    }
                };
                this.provider.getServiceConfigurator(managerServiceName, configuration).configure(context).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                ServiceConfigurator factoryConfigurator = new SingleSignOnSessionFactoryServiceConfigurator(securityDomainName).configure(context, ssoModel);
                factoryConfigurator.build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                Supplier singleSignOnSessionFactorySupplier = serviceBuilder.requires(factoryConfigurator.getServiceName());
                UnaryOperator transformer = arg_0 -> AddHandler.lambda$performRuntime$1((Supplier)singleSignOnSessionFactorySupplier, singleSignOnConfiguration, arg_0);
                transformerSupplier = () -> transformer;
            } else {
                transformerSupplier = () -> null;
            }
            Consumer valueConsumer = serviceBuilder.provides(new ServiceName[]{applicationSecurityDomainName});
            ApplicationSecurityDomainService service = new ApplicationSecurityDomainService(overrideDeploymentConfig, enableJacc, enableJaspi, integratedJaspi, factoryFunction, transformerSupplier, valueConsumer);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
            KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getAttachment(KNOWN_DEPLOYMENTS_KEY);
            knownDeploymentsApi.setApplicationSecurityDomainService(service);
        }

        private static /* synthetic */ HttpServerAuthenticationMechanismFactory lambda$performRuntime$1(Supplier singleSignOnSessionFactorySupplier, SingleSignOnServerMechanismFactory.SingleSignOnConfiguration singleSignOnConfiguration, HttpServerAuthenticationMechanismFactory factory) {
            return new SingleSignOnServerMechanismFactory(factory, (SingleSignOnSessionFactory)singleSignOnSessionFactorySupplier.get(), singleSignOnConfiguration);
        }

        private static /* synthetic */ HttpAuthenticationFactory lambda$performRuntime$0(Supplier httpAuthenticationFactorySupplier, String s) {
            return (HttpAuthenticationFactory)httpAuthenticationFactorySupplier.get();
        }
    }

    private static class ReferencingDeploymentsHandler
    implements OperationStepHandler {
        private ReferencingDeploymentsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isDefaultRequiresRuntime()) {
                context.addStep((ctx, op) -> {
                    KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getCapabilityRuntimeAPI("org.wildfly.undertow.application-security-domain.known-deployments", ctx.getCurrentAddressValue(), KnownDeploymentsApi.class);
                    ModelNode deploymentList = new ModelNode();
                    for (String current : knownDeploymentsApi.getKnownDeployments()) {
                        deploymentList.add(current);
                    }
                    context.getResult().set(deploymentList);
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
}

