/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.AuthorizationValidatingHandler;
import org.jboss.as.domain.management.security.SecurityRealmParentRestartHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class SecurityRealmChildAddHandler
extends SecurityRealmParentRestartHandler {
    private final boolean validateAuthentication;
    private final boolean validateAuthorization;
    private final AttributeDefinition[] attributeDefinitions;
    private final Set<RuntimeCapability> capabilities;

    public SecurityRealmChildAddHandler(boolean validateAuthentication, boolean validateAuthorization, AttributeDefinition ... attributeDefinitions) {
        this(validateAuthentication, validateAuthorization, Collections.emptySet(), attributeDefinitions);
    }

    public SecurityRealmChildAddHandler(boolean validateAuthentication, boolean validateAuthorization, Set<RuntimeCapability> capabilities, AttributeDefinition ... attributeDefinitions) {
        super(new RuntimeCapability[0]);
        this.capabilities = capabilities == null ? Collections.emptySet() : capabilities;
        this.validateAuthentication = validateAuthentication;
        this.validateAuthorization = validateAuthorization;
        this.attributeDefinitions = attributeDefinitions == null ? new AttributeDefinition[]{} : attributeDefinitions;
    }

    @Override
    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return false;
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        for (AttributeDefinition attr : this.attributeDefinitions) {
            attr.validateAndSet(operation, model);
        }
        if (!context.isBooting()) {
            ModelNode validationOp;
            if (this.validateAuthentication) {
                validationOp = AuthenticationValidatingHandler.createOperation(operation);
                context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
            }
            if (this.validateAuthorization) {
                validationOp = AuthorizationValidatingHandler.createOperation(operation);
                context.addStep(validationOp, (OperationStepHandler)AuthorizationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
            }
        }
        this.recordCapabilitiesAndRequirements(context, operation, resource);
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set capabilitySet = this.capabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.capabilities;
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.registerCapability(capability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(capability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition ad : this.attributeDefinitions) {
            if (!model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
            ad.addCapabilityRequirements(context, resource, model.get(ad.getName()));
        }
    }
}

