/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.converter;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aesh.command.converter.Converter;
import org.aesh.command.impl.converter.BooleanConverter;
import org.aesh.command.impl.converter.ByteConverter;
import org.aesh.command.impl.converter.CharacterConverter;
import org.aesh.command.impl.converter.DoubleConverter;
import org.aesh.command.impl.converter.FileConverter;
import org.aesh.command.impl.converter.FileResourceConverter;
import org.aesh.command.impl.converter.FloatConverter;
import org.aesh.command.impl.converter.IntegerConverter;
import org.aesh.command.impl.converter.LongConverter;
import org.aesh.command.impl.converter.ShortConverter;
import org.aesh.command.impl.converter.StringConverter;
import org.aesh.io.Resource;

public class CLConverterManager {
    private Map<Class, Converter> converters;

    public static CLConverterManager getInstance() {
        return CLConvertManagerHolder.INSTANCE;
    }

    private CLConverterManager() {
        this.initMap();
    }

    private void initMap() {
        this.converters = new HashMap<Class, Converter>();
        this.converters.put(Integer.class, new IntegerConverter());
        this.converters.put(Integer.TYPE, this.converters.get(Integer.class));
        this.converters.put(Boolean.class, new BooleanConverter());
        this.converters.put(Boolean.TYPE, this.converters.get(Boolean.class));
        this.converters.put(Character.class, new CharacterConverter());
        this.converters.put(Character.TYPE, this.converters.get(Character.class));
        this.converters.put(Double.class, new DoubleConverter());
        this.converters.put(Double.TYPE, this.converters.get(Double.class));
        this.converters.put(Float.class, new FloatConverter());
        this.converters.put(Float.TYPE, this.converters.get(Float.class));
        this.converters.put(Long.class, new LongConverter());
        this.converters.put(Long.TYPE, this.converters.get(Long.class));
        this.converters.put(Short.class, new ShortConverter());
        this.converters.put(Short.TYPE, this.converters.get(Short.class));
        this.converters.put(Byte.class, new ByteConverter());
        this.converters.put(Byte.TYPE, this.converters.get(Byte.class));
        this.converters.put(String.class, new StringConverter());
        this.converters.put(File.class, new FileConverter());
        this.converters.put(Resource.class, new FileResourceConverter());
    }

    public boolean hasConverter(Class clazz) {
        return this.converters.containsKey(clazz);
    }

    public Converter getConverter(Class clazz) {
        return this.converters.get(clazz);
    }

    public void setConverter(Class<?> clazz, Converter converter) {
        this.converters.put(clazz, converter);
    }

    public Set<Class> getConvertedTypes() {
        return Collections.unmodifiableSet(this.converters.keySet());
    }

    private static class CLConvertManagerHolder {
        static final CLConverterManager INSTANCE = new CLConverterManager();

        private CLConvertManagerHolder() {
        }
    }
}

