/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.management.MBeanServerConnection;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.ConnectDialog;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.impl.ExistingChannelModelControllerClient;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remotingjmx.RemotingMBeanServerConnection;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class JConsoleCLIPlugin
extends JConsolePlugin {
    private static final String MSG_CANNOT_ESTABLISH_CONNECTION = "Cannot establish a remote connection to the application server";
    private static final int DEFAULT_MAX_THREADS = 6;
    private static final String LABEL = "WildFly CLI";
    private static final AtomicInteger executorCount = new AtomicInteger();
    private final Logger log = Logger.getLogger((String)JConsoleCLIPlugin.class.getName());
    private ConnectDialog dialog;
    CliGuiContext cliGuiCtx;
    private JPanel jconsolePanel;
    private boolean initComplete = false;
    private ModelControllerClient connectedClient;
    private boolean isConnected = false;
    private ComponentListener doConnectListener;

    @Override
    public Map<String, JPanel> getTabs() {
        HashMap<String, JPanel> panelMap = new HashMap<String, JPanel>();
        this.jconsolePanel = new JPanel(new BorderLayout());
        this.dialog = new ConnectDialog(this, this.jconsolePanel);
        this.doConnectListener = new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
                try {
                    if (!JConsoleCLIPlugin.this.isConnected) {
                        JConsoleCLIPlugin.this.connect();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error connecting to JBoss AS.", e);
                }
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                if (JConsoleCLIPlugin.this.dialog.isStarted()) {
                    JConsoleCLIPlugin.this.dialog.stop();
                }
            }
        };
        this.jconsolePanel.addComponentListener(this.doConnectListener);
        panelMap.put(LABEL, this.jconsolePanel);
        return panelMap;
    }

    private void connect() throws Exception {
        JConsoleContext jcCtx = this.getContext();
        MBeanServerConnection mbeanServerConn = jcCtx.getMBeanServerConnection();
        if (mbeanServerConn instanceof RemotingMBeanServerConnection) {
            CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext();
            if (this.connectUsingRemoting(cmdCtx, (RemotingMBeanServerConnection)mbeanServerConn)) {
                jcCtx.addPropertyChangeListener(evt -> {
                    this.log.tracef("Received property change %s value %s", (Object)evt.getPropertyName(), evt.getNewValue());
                    if ("connectionState".equals(evt.getPropertyName())) {
                        JConsoleContext.ConnectionState state = (JConsoleContext.ConnectionState)((Object)((Object)evt.getNewValue()));
                        if (state == JConsoleContext.ConnectionState.CONNECTED) {
                            try {
                                RemotingMBeanServerConnection rmbsc = (RemotingMBeanServerConnection)this.getContext().getMBeanServerConnection();
                                this.connectUsingRemoting(cmdCtx, rmbsc);
                                this.connectedClient = cmdCtx.getModelControllerClient();
                                this.isConnected = true;
                            }
                            catch (Exception ex) {
                                this.log.error(null, (Throwable)ex);
                            }
                        } else {
                            this.isConnected = false;
                        }
                    }
                });
                this.connectedClient = cmdCtx.getModelControllerClient();
                Supplier<ModelControllerClient> client = () -> this.connectedClient;
                this.init(cmdCtx, client);
            } else {
                JOptionPane.showInternalMessageDialog(this.jconsolePanel, MSG_CANNOT_ESTABLISH_CONNECTION);
            }
        } else {
            this.dialog.start();
        }
    }

    private boolean connectUsingRemoting(CommandContext cmdCtx, RemotingMBeanServerConnection rmtMBeanSvrConn) throws IOException, CliInitializationException {
        Connection conn = rmtMBeanSvrConn.getConnection();
        IoFuture futureChannel = conn.openChannel("management", OptionMap.EMPTY);
        IoFuture.Status result = futureChannel.await(5L, TimeUnit.SECONDS);
        if (result != IoFuture.Status.DONE) {
            futureChannel.cancel();
            return false;
        }
        Channel channel = (Channel)futureChannel.get();
        ModelControllerClient modelCtlrClient = ExistingChannelModelControllerClient.createReceiving((Channel)channel, (ExecutorService)this.createExecutor());
        cmdCtx.bindClient(modelCtlrClient);
        return true;
    }

    private ExecutorService createExecutor() {
        final ThreadGroup group = new ThreadGroup("management-client-thread");
        ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(group, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null);
            }
        });
        return EnhancedQueueExecutor.DISABLE_HINT ? new ThreadPoolExecutor(2, 6, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory) : new EnhancedQueueExecutor.Builder().setCorePoolSize(2).setMaximumPoolSize(6).setKeepAliveTime(60L, TimeUnit.SECONDS).setThreadFactory(threadFactory).build();
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        if (!this.initComplete && this.isConnected) {
            this.initComplete = true;
            this.configureMyJInternalFrame();
        }
        return null;
    }

    public void init(CommandContext cmdCtx) {
        this.init(cmdCtx, null);
    }

    private void init(CommandContext cmdCtx, Supplier<ModelControllerClient> client) {
        this.cliGuiCtx = GuiMain.startEmbedded(cmdCtx, client);
        JPanel cliGuiPanel = this.cliGuiCtx.getMainPanel();
        this.jconsolePanel.setVisible(false);
        this.dialog.stop();
        this.jconsolePanel.add((Component)GuiMain.makeMenuBar(this.cliGuiCtx), "North");
        this.jconsolePanel.add((Component)cliGuiPanel, "Center");
        this.jconsolePanel.setVisible(true);
        this.jconsolePanel.repaint();
        this.isConnected = true;
    }

    private void configureMyJInternalFrame() {
        ImageIcon icon = new ImageIcon(GuiMain.getJBossIcon());
        Container component = this.jconsolePanel;
        while (component != null) {
            if (!((component = component.getParent()) instanceof JInternalFrame)) continue;
            JInternalFrame frame = (JInternalFrame)component;
            frame.setFrameIcon(icon);
            return;
        }
    }
}

