/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.io.File;
import org.aesh.utils.Config;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class BatchRunHandler
extends BaseOperationCommand {
    private final ArgumentWithValue file;
    private final ArgumentWithoutValue verbose;

    public BatchRunHandler(CommandContext ctx) {
        super(ctx, "batch-run", true);
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.file = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, "--file");
        this.verbose = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--verbose", "-v");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        OperationResponse response;
        boolean v = this.verbose.isPresent(ctx.getParsedCommandLine());
        boolean failed = false;
        boolean hasFile = this.file.getValue(ctx.getParsedCommandLine()) != null;
        try {
            ModelNode request = this.buildRequest(ctx);
            OperationBuilder builder = new OperationBuilder(request, true);
            for (String path : this.getAttachments(ctx).getAttachedFiles()) {
                builder.addFileAsAttachment(new File(path));
            }
            ModelControllerClient client = ctx.getModelControllerClient();
            try {
                response = client.executeOperation(builder.build(), OperationMessageHandler.DISCARD);
            }
            catch (Exception e) {
                throw new CommandFormatException("Failed to perform operation: " + e.getLocalizedMessage());
            }
            if (!Util.isSuccess(response.getResponseNode())) {
                String msg = BatchRunHandler.formatBatchError(ctx, response.getResponseNode());
                if (msg == null) {
                    msg = Util.getFailureDescription(response.getResponseNode());
                }
                throw new CommandFormatException(msg);
            }
            ModelNode steps = response.getResponseNode().get("result");
            if (steps.isDefined()) {
                Batch batch = ctx.getBatchManager().getActiveBatch();
                int i = 1;
                for (BatchedCommand cmd : batch.getCommands()) {
                    ModelNode step = steps.get("step-" + i);
                    if (!step.isDefined()) continue;
                    if (cmd.getResponseHandler() != null) {
                        cmd.getResponseHandler().handleResponse(step, response);
                    }
                    ++i;
                }
            }
        }
        catch (CommandLineException e) {
            failed = true;
            if (hasFile) {
                throw new CommandLineException("The batch failed with the following error: ", e);
            }
            throw new CommandLineException("The batch failed with the following error (you are remaining in the batch editing mode to have a chance to correct the error)", e);
        }
        finally {
            if (hasFile) {
                ctx.getBatchManager().discardActiveBatch();
            } else if (!failed && ctx.getBatchManager().isBatchActive()) {
                ctx.getBatchManager().discardActiveBatch();
            }
        }
        if (v) {
            ctx.printDMR(response.getResponseNode());
        } else {
            ctx.printLine("The batch executed successfully");
            super.handleResponse(ctx, response.getResponseNode(), true);
        }
    }

    private static String formatBatchError(CommandContext ctx, ModelNode responseNode) {
        if (responseNode == null) {
            return null;
        }
        ModelNode mn = responseNode.get("result");
        String msg = null;
        try {
            if (mn.isDefined()) {
                int index = 0;
                Batch batch = ctx.getBatchManager().getActiveBatch();
                StringBuilder b = new StringBuilder();
                ModelNode fd = responseNode.get("failure-description");
                if (fd.isDefined()) {
                    Property p = fd.asProperty();
                    b.append(Config.getLineSeparator()).append(p.getName()).append(Config.getLineSeparator());
                    boolean foundError = false;
                    for (Property prop : mn.asPropertyList()) {
                        ModelNode val = prop.getValue();
                        if (val.hasDefined("failure-description")) {
                            b.append("Step: step-").append(index + 1).append(Config.getLineSeparator());
                            b.append("Operation: ").append(batch.getCommands().get(index).getCommand()).append(Config.getLineSeparator());
                            b.append("Failure: ").append(val.get("failure-description").asString()).append(Config.getLineSeparator());
                            foundError = true;
                        }
                        ++index;
                    }
                    if (foundError) {
                        msg = b.toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ModelNode buildRequestWOValidation(CommandContext ctx) throws CommandFormatException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Attachments getAttachments(CommandContext ctx) {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            Batch batch = batchManager.getActiveBatch();
            return batch.getAttachments();
        }
        return new Attachments();
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandLineException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        throw new UnsupportedOperationException();
    }
}

