/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import java.util.HashSet;
import java.util.Set;
import org.aesh.command.impl.internal.ParsedCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.AbstractEnableSSLCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.ManagementEnableSSLCommand;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependOneOfOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractDependRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.AbstractRejectOptionActivator;
import org.wildfly.core.cli.command.aesh.activator.DependOneOfOptionActivator;

public interface OptionActivators {

    public static class SecureSocketBindingActivator
    extends AbstractDependOptionActivator {
        public SecureSocketBindingActivator() {
            super(false, "management-interface");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            ManagementEnableSSLCommand cmd = (ManagementEnableSSLCommand)processedCommand.command();
            if (cmd.managementInterface == null) {
                return false;
            }
            return "http-interface".equals(cmd.managementInterface);
        }
    }

    public static class KeyStorePathDependentActivator
    extends AbstractDependOptionActivator {
        public KeyStorePathDependentActivator() {
            super(false, "key-store-path");
        }
    }

    public static class NoOverrideSecurityRealmActivator
    extends AbstractDependOneOfOptionActivator {
        public NoOverrideSecurityRealmActivator() {
            super("key-store-path", "key-store-name");
        }
    }

    public static class NoReloadActivator
    extends AbstractDependOneOfOptionActivator {
        public NoReloadActivator() {
            super("key-store-path", "key-store-name", "interactive");
        }
    }

    public static class ValidateTrustedCertificateActivator
    extends AbstractDependOptionActivator {
        public ValidateTrustedCertificateActivator() {
            super(false, "trusted-certificate-path");
        }
    }

    public static class TrustedCertificateActivator
    extends AbstractRejectOptionActivator
    implements DependOneOfOptionActivator {
        private static DependsOnOf dof = new DependsOnOf();

        public TrustedCertificateActivator() {
            super("trust-store-name");
        }

        @Override
        public Set<String> getOneOfDependsOn() {
            return dof.getOneOfDependsOn();
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            AbstractEnableSSLCommand cmd = (AbstractEnableSSLCommand)processedCommand.command();
            try {
                if (!ElytronUtil.isKeyStoreManagementSupported(cmd.getCommandContext())) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            if (!dof.isActivated(processedCommand)) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        private static class DependsOnOf
        extends AbstractDependOneOfOptionActivator {
            DependsOnOf() {
                super("key-store-name", "key-store-path");
            }
        }
    }

    public static class ManagementInterfaceActivator
    extends AbstractDependOneOfOptionActivator {
        public ManagementInterfaceActivator() {
            super("key-store-path", "key-store-name", "interactive");
        }
    }

    public static class NewKeyManagerNameActivator
    extends AbstractDependOneOfOptionActivator {
        public NewKeyManagerNameActivator() {
            super("key-store-path", "key-store-name");
        }
    }

    public static class NewSSLContextNameActivator
    extends AbstractDependOneOfOptionActivator {
        public NewSSLContextNameActivator() {
            super("key-store-path", "key-store-name");
        }
    }

    public static class NewKeyStoreNameActivator
    extends AbstractDependOptionActivator {
        public NewKeyStoreNameActivator() {
            super(false, "key-store-path");
        }
    }

    public static class TrustStoreFilePasswordActivator
    extends AbstractDependOptionActivator {
        public TrustStoreFilePasswordActivator() {
            super(false, "trusted-certificate-path");
        }
    }

    public static class NewTrustManagerNameActivator
    extends AbstractDependOneOfOptionActivator {
        public NewTrustManagerNameActivator() {
            super("trusted-certificate-path", "trust-store-name");
        }
    }

    public static class NewTrustStoreNameActivator
    extends AbstractDependOptionActivator {
        public NewTrustStoreNameActivator() {
            super(false, "trusted-certificate-path");
        }
    }

    public static class TrustStoreFileNameActivator
    extends AbstractDependRejectOptionActivator {
        private static final Set<String> DEPEND = new HashSet<String>();
        private static final Set<String> REJECT = new HashSet<String>();

        public TrustStoreFileNameActivator() {
            super(false, DEPEND, REJECT);
        }

        static {
            DEPEND.add("trusted-certificate-path");
            REJECT.add("trust-store-name");
        }
    }

    public static class TrustStoreNameActivator
    extends AbstractRejectOptionActivator
    implements DependOneOfOptionActivator {
        private static DependsOnOf dof = new DependsOnOf();

        public TrustStoreNameActivator() {
            super("trusted-certificate-path");
        }

        @Override
        public Set<String> getOneOfDependsOn() {
            return dof.getOneOfDependsOn();
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            if (!dof.isActivated(processedCommand)) {
                return false;
            }
            return super.isActivated(processedCommand);
        }

        private static class DependsOnOf
        extends AbstractDependOneOfOptionActivator {
            DependsOnOf() {
                super("key-store-name", "key-store-path");
            }
        }
    }

    public static class KeyStoreNameActivator
    extends AbstractRejectOptionActivator {
        public KeyStoreNameActivator() {
            super("key-store-path", "interactive");
        }
    }

    public static class KeyStorePathActivator
    extends AbstractRejectOptionActivator {
        public KeyStorePathActivator() {
            super("key-store-name", "interactive");
        }
    }

    public static class InteractiveActivator
    extends AbstractRejectOptionActivator {
        public InteractiveActivator() {
            super("key-store-name", "key-store-path");
        }

        @Override
        public boolean isActivated(ParsedCommand processedCommand) {
            AbstractEnableSSLCommand cmd = (AbstractEnableSSLCommand)processedCommand.command();
            try {
                if (!ElytronUtil.isKeyStoreManagementSupported(cmd.getCommandContext())) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return super.isActivated(processedCommand);
        }
    }
}

