/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.dmr.ModelNode;

public class ServerStopHandler
implements OperationStepHandler {
    private final ServerInventory serverInventory;

    public ServerStopHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ServerRootResourceDefinition.renameTimeoutToSuspendTimeout((ModelNode)operation);
        final String serverName = context.getCurrentAddressValue();
        final boolean blocking = ServerRootResourceDefinition.BLOCKING.resolveModelAttribute(context, operation).asBoolean();
        final int timeout = ServerRootResourceDefinition.SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                ServerStatus status = ServerStopHandler.this.serverInventory.stopServer(serverName, timeout, blocking);
                try {
                    context.readResource(PathAddress.EMPTY_ADDRESS, false);
                }
                catch (Resource.NoSuchResourceException noSuchResourceException) {
                    // empty catch block
                }
                context.getResult().set(status.toString());
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

