/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.spi.id.inline;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.inline.AbstractInlineIdsBulkIdHandler;
import org.hibernate.hql.spi.id.inline.IdsClauseBuilder;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.sql.Update;

public abstract class AbstractInlineIdsUpdateHandlerImpl
extends AbstractInlineIdsBulkIdHandler
implements MultiTableBulkIdStrategy.UpdateHandler {
    private final Map<Integer, String> updates = new LinkedHashMap<Integer, String>();
    private ParameterSpecification[][] assignmentParameterSpecifications;

    public AbstractInlineIdsUpdateHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        super(factory, walker);
    }

    @Override
    public String[] getSqlStatements() {
        return this.updates.values().toArray(new String[this.updates.values().size()]);
    }

    @Override
    public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
        IdsClauseBuilder values = this.prepareInlineStatement(session, queryParameters);
        if (!values.getIds().isEmpty()) {
            Object update;
            String[] tableNames = this.getTargetedQueryable().getConstraintOrderedTableNameClosure();
            String[][] columnNames = this.getTargetedQueryable().getContraintOrderedTableKeyColumnClosure();
            String idSubselect = values.toStatement();
            this.assignmentParameterSpecifications = new ParameterSpecification[tableNames.length][];
            for (int tableIndex = 0; tableIndex < tableNames.length; ++tableIndex) {
                boolean affected = false;
                ArrayList parameterList = new ArrayList();
                update = this.generateUpdate(tableNames[tableIndex], columnNames[tableIndex], idSubselect, "bulk update");
                ArrayList assignmentSpecifications = this.walker().getAssignmentSpecifications();
                for (AssignmentSpecification assignmentSpecification : assignmentSpecifications) {
                    if (!assignmentSpecification.affectsTable(tableNames[tableIndex])) continue;
                    affected = true;
                    ((Update)update).appendAssignmentFragment(assignmentSpecification.getSqlAssignmentFragment());
                    if (assignmentSpecification.getParameters() == null) continue;
                    Collections.addAll(parameterList, assignmentSpecification.getParameters());
                }
                if (!affected) continue;
                this.updates.put(tableIndex, ((Update)update).toStatementString());
                this.assignmentParameterSpecifications[tableIndex] = parameterList.toArray(new ParameterSpecification[parameterList.size()]);
            }
            for (Map.Entry<Integer, String> updateEntry : this.updates.entrySet()) {
                int i = updateEntry.getKey();
                update = updateEntry.getValue();
                if (update == null) continue;
                try {
                    PreparedStatement ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement((String)update, false);
                    Object object = null;
                    try {
                        int position = 1;
                        if (this.assignmentParameterSpecifications[i] != null) {
                            for (int x = 0; x < this.assignmentParameterSpecifications[i].length; ++x) {
                                position += this.assignmentParameterSpecifications[i][x].bind(ps, queryParameters, session, position);
                            }
                        }
                        session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ps == null) continue;
                        if (object != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    throw this.convert(e, "error performing bulk update", (String)update);
                }
            }
        }
        return values.getIds().size();
    }

    protected Update generateUpdate(String tableName, String[] columnNames, String idSubselect, String comment) {
        Update update = new Update(this.factory().getServiceRegistry().getService(JdbcServices.class).getDialect()).setTableName(tableName).setWhere("(" + String.join((CharSequence)", ", columnNames) + ") in (" + idSubselect + ")");
        if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
            update.setComment(comment);
        }
        return update;
    }
}

