/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;

public class ClassLoaderThreadFactory
implements ThreadFactory {
    private final ThreadFactory factory;
    private final ClassLoader loader;

    public ClassLoaderThreadFactory(ThreadFactory factory, ClassLoader loader) {
        this.factory = factory;
        this.loader = loader;
    }

    @Override
    public Thread newThread(Runnable r) {
        Runnable task = () -> {
            try {
                r.run();
            }
            finally {
                this.setContextClassLoader(Thread.currentThread());
            }
        };
        return this.setContextClassLoader(this.factory.newThread(task));
    }

    private Thread setContextClassLoader(Thread thread) {
        PrivilegedAction<Thread> action = () -> {
            thread.setContextClassLoader(this.loader);
            return thread;
        };
        return AccessController.doPrivileged(action);
    }
}

