/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public class SaltedHashPasswordSpec
implements PasswordSpec {
    private final byte[] hash;
    private final byte[] salt;

    public SaltedHashPasswordSpec(byte[] hash, byte[] salt) {
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        this.hash = hash;
        this.salt = salt;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SaltedHashPasswordSpec)) {
            return false;
        }
        SaltedHashPasswordSpec o = (SaltedHashPasswordSpec)other;
        return Arrays.equals(this.hash, o.hash) && Arrays.equals(this.salt, o.salt);
    }

    public int hashCode() {
        return HashMath.multiHashOrdered((int)Arrays.hashCode(this.hash), (int)Arrays.hashCode(this.salt));
    }
}

