/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.datasource;

import javax.sql.DataSource;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessorRegistry;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public class DefaultDataSourceResourceReferenceProcessor
implements DeploymentUnitProcessor {
    private static final DatasourceResourceReferenceProcessor RESOURCE_REFERENCE_PROCESSOR = new DatasourceResourceReferenceProcessor();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        EEResourceReferenceProcessorRegistry eeResourceReferenceProcessorRegistry;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() == null && (eeResourceReferenceProcessorRegistry = (EEResourceReferenceProcessorRegistry)deploymentUnit.getAttachment(Attachments.RESOURCE_REFERENCE_PROCESSOR_REGISTRY)) != null) {
            eeResourceReferenceProcessorRegistry.registerResourceReferenceProcessor((EEResourceReferenceProcessor)RESOURCE_REFERENCE_PROCESSOR);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class DatasourceResourceReferenceProcessor
    implements EEResourceReferenceProcessor {
        private static final String TYPE = DataSource.class.getName();
        private static final InjectionSource INJECTION_SOURCE = new LookupInjectionSource("java:comp/DefaultDataSource");

        private DatasourceResourceReferenceProcessor() {
        }

        public String getResourceReferenceType() {
            return TYPE;
        }

        public InjectionSource getResourceReferenceBindingSource() throws DeploymentUnitProcessingException {
            return INJECTION_SOURCE;
        }
    }
}

