/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.remoting3.Connection;
import org.wildfly.common.Assert;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.common.net.Inet;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryResult;

final class NodeInformation {
    private final String nodeName;
    private final ConcurrentMap<EJBClientChannel, Set<EJBModuleIdentifier>> modulesByConnection = new ConcurrentHashMap<EJBClientChannel, Set<EJBModuleIdentifier>>(1);
    private final ConcurrentMap<String, ClusterNodeInformation> clustersByName = new ConcurrentHashMap<String, ClusterNodeInformation>(1);
    private final ConcurrentMap<EJBClientChannel, InetSocketAddress> addressesByConnection = new ConcurrentHashMap<EJBClientChannel, InetSocketAddress>(1);
    private volatile List<ServiceURL> serviceURLCache;
    private volatile boolean invalid;

    NodeInformation(String nodeName) {
        this.nodeName = nodeName;
    }

    String getNodeName() {
        return this.nodeName;
    }

    boolean discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult discoveryResult) {
        if (this.invalid) {
            return false;
        }
        boolean found = false;
        List<ServiceURL> serviceURLCache = this.getServiceURLCache();
        for (ServiceURL serviceURL : serviceURLCache) {
            if (!serviceURL.satisfies(filterSpec) || !serviceType.implies(serviceURL)) continue;
            found = true;
            discoveryResult.addMatch(serviceURL);
        }
        return found;
    }

    ConcurrentMap<String, ClusterNodeInformation> getClustersByName() {
        return this.clustersByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceURL> getServiceURLCache() {
        List<ServiceURL> serviceURLCache = this.serviceURLCache;
        if (serviceURLCache == null) {
            NodeInformation nodeInformation = this;
            synchronized (nodeInformation) {
                serviceURLCache = this.serviceURLCache;
                if (serviceURLCache == null) {
                    URI peerURI;
                    Connection peerConnection;
                    EJBClientChannel channel;
                    serviceURLCache = new ArrayList<ServiceURL>();
                    HashMap<URI, TempInfo> map = new HashMap<URI, TempInfo>();
                    for (Map.Entry entry : this.modulesByConnection.entrySet()) {
                        channel = (EJBClientChannel)entry.getKey();
                        peerConnection = channel.getChannel().getConnection();
                        peerURI = this.buildURI(peerConnection.getProtocol(), peerConnection.getPeerAddress(InetSocketAddress.class));
                        TempInfo tempInfo = new TempInfo(peerURI);
                        tempInfo.modules = (Set)entry.getValue();
                        map.put(tempInfo.destination, tempInfo);
                    }
                    for (Map.Entry entry : this.addressesByConnection.entrySet()) {
                        channel = (EJBClientChannel)entry.getKey();
                        peerConnection = channel.getChannel().getConnection();
                        peerURI = this.buildURI(peerConnection.getProtocol(), peerConnection.getPeerAddress(InetSocketAddress.class));
                        map.computeIfAbsent(peerURI, TempInfo::new);
                    }
                    for (Map.Entry entry : this.clustersByName.entrySet()) {
                        String clusterName = (String)entry.getKey();
                        ClusterNodeInformation clusterNodeInformation = (ClusterNodeInformation)entry.getValue();
                        for (Map.Entry<String, CidrAddressTable<InetSocketAddress>> entry2 : clusterNodeInformation.getAddressTablesByProtocol().entrySet()) {
                            String protocol = entry2.getKey();
                            CidrAddressTable<InetSocketAddress> table = entry2.getValue();
                            for (CidrAddressTable.Mapping<InetSocketAddress> mapping : table) {
                                CidrAddress cidrAddress = mapping.getRange();
                                InetSocketAddress address = mapping.getValue();
                                URI uri = this.buildURI(protocol, address);
                                TempInfo tempInfo = map.computeIfAbsent(uri, TempInfo::new);
                                if (tempInfo.clusters == null) {
                                    tempInfo.clusters = new HashMap<String, CidrAddress>();
                                }
                                tempInfo.clusters.put(clusterName, cidrAddress);
                            }
                        }
                    }
                    AttributeValue nodeNameValue = AttributeValue.fromString(this.nodeName);
                    for (TempInfo info : map.values()) {
                        ServiceURL.Builder builder = new ServiceURL.Builder();
                        builder.setUri(info.destination);
                        builder.setAbstractType(EJBClientContext.EJB_SERVICE_TYPE.getAbstractType());
                        builder.setAbstractTypeAuthority(EJBClientContext.EJB_SERVICE_TYPE.getAbstractTypeAuthority());
                        builder.addAttribute("node", nodeNameValue);
                        if (info.modules != null) {
                            for (EJBModuleIdentifier eJBModuleIdentifier : info.modules) {
                                String appName = eJBModuleIdentifier.getAppName();
                                String moduleName = eJBModuleIdentifier.getModuleName();
                                String distinctName = eJBModuleIdentifier.getDistinctName();
                                if (distinctName.isEmpty()) {
                                    if (appName.isEmpty()) {
                                        builder.addAttribute("ejb-module", AttributeValue.fromString(moduleName));
                                        continue;
                                    }
                                    builder.addAttribute("ejb-module", AttributeValue.fromString(appName + "/" + moduleName));
                                    continue;
                                }
                                if (appName.isEmpty()) {
                                    builder.addAttribute("ejb-module-distinct", AttributeValue.fromString(moduleName + "/" + distinctName));
                                    continue;
                                }
                                builder.addAttribute("ejb-module-distinct", AttributeValue.fromString(appName + "/" + moduleName + "/" + distinctName));
                            }
                        }
                        serviceURLCache.add(builder.create());
                        if (info.clusters == null) continue;
                        for (Map.Entry entry : info.clusters.entrySet()) {
                            String clusterName = (String)entry.getKey();
                            builder.addAttribute("cluster", AttributeValue.fromString(clusterName));
                            CidrAddress cidrAddress = (CidrAddress)entry.getValue();
                            if (cidrAddress.getNetmaskBits() == 0) {
                                builder.removeAttribute("source-ip");
                            } else {
                                AttributeValue value = AttributeValue.fromString(cidrAddress.toString());
                                builder.addAttribute("source-ip", value);
                            }
                            serviceURLCache.add(builder.create());
                        }
                    }
                    this.serviceURLCache = serviceURLCache;
                }
            }
        }
        return serviceURLCache;
    }

    private URI buildURI(String protocol, InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        String hostName = Inet.getHostNameIfResolved(socketAddress);
        if (hostName == null) {
            hostName = address instanceof Inet6Address ? '[' + Inet.toOptimalString(address) + ']' : Inet.toOptimalString(address);
        }
        try {
            return new URI(protocol, null, hostName, socketAddress.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            Assert.unreachableCode();
            return null;
        }
    }

    boolean isInvalid() {
        return this.invalid;
    }

    void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAddress(String protocol, String clusterName, CidrAddress block, InetSocketAddress destination) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.serviceURLCache = null;
            this.clustersByName.computeIfAbsent(clusterName, name -> new ClusterNodeInformation()).getAddressTablesByProtocol().computeIfAbsent(protocol, ignored -> new CidrAddressTable()).put(block, destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCluster(String clusterName) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.serviceURLCache = null;
            this.clustersByName.remove(clusterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModules(EJBClientChannel clientChannel, EJBModuleIdentifier[] moduleList) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.serviceURLCache = null;
            Collections.addAll(this.modulesByConnection.computeIfAbsent(clientChannel, ignored -> new HashSet()), moduleList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModules(EJBClientChannel clientChannel, HashSet<EJBModuleIdentifier> toRemove) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.serviceURLCache = null;
            Set set = (Set)this.modulesByConnection.get(clientChannel);
            if (set != null) {
                set.removeAll(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModule(EJBClientChannel clientChannel, EJBModuleIdentifier toRemove) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.serviceURLCache = null;
            Set set = (Set)this.modulesByConnection.get(clientChannel);
            if (set != null) {
                set.remove(toRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAddress(EJBClientChannel clientChannel) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            this.addressesByConnection.put(clientChannel, (InetSocketAddress)clientChannel.getChannel().getConnection().getPeerAddress());
            this.serviceURLCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(EJBClientChannel clientChannel) {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            boolean addressRemoved;
            boolean moduleRemoved = this.modulesByConnection.remove(clientChannel) != null;
            boolean bl = addressRemoved = this.addressesByConnection.remove(clientChannel) != null;
            if (moduleRemoved || addressRemoved) {
                this.serviceURLCache = null;
            }
        }
    }

    static final class ClusterNodeInformation {
        private final Map<String, CidrAddressTable<InetSocketAddress>> addressTablesByProtocol = new HashMap<String, CidrAddressTable<InetSocketAddress>>();

        ClusterNodeInformation() {
        }

        Map<String, CidrAddressTable<InetSocketAddress>> getAddressTablesByProtocol() {
            return this.addressTablesByProtocol;
        }
    }

    static class TempInfo {
        Map<String, CidrAddress> clusters;
        Set<EJBModuleIdentifier> modules;
        URI destination;

        TempInfo(URI destination) {
            this.destination = destination;
        }
    }
}

