/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.NotSerializableException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapPutFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapPutFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapRemoveFunction;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributes;

public class FineSessionAttributes<NK, K, V>
implements SessionAttributes {
    private final NK key;
    private final Map<NK, Map<String, UUID>> namesCache;
    private final Function<UUID, K> keyFactory;
    private final Map<K, V> attributeCache;
    private final Map<UUID, Mutator> mutations = new ConcurrentHashMap<UUID, Mutator>();
    private final Marshaller<Object, V> marshaller;
    private final BiFunction<K, V, Mutator> mutatorFactory;
    private final Immutability immutability;
    private final CacheProperties properties;
    private volatile Map<String, UUID> names;

    public FineSessionAttributes(NK key, Map<String, UUID> names, Map<NK, Map<String, UUID>> namesCache, Function<UUID, K> keyFactory, Map<K, V> attributeCache, Marshaller<Object, V> marshaller, BiFunction<K, V, Mutator> mutatorFactory, Immutability immutability, CacheProperties properties) {
        this.key = key;
        this.setNames(names);
        this.namesCache = namesCache;
        this.keyFactory = keyFactory;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.mutatorFactory = mutatorFactory;
        this.immutability = immutability;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        this.setNames(this.namesCache.computeIfPresent(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteMapRemoveFunction((Object)name) : new ConcurrentMapRemoveFunction((Object)name))));
        Object result = this.read(this.attributeCache.remove(this.keyFactory.apply(attributeId)));
        this.mutations.remove(attributeId);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException(new NotSerializableException(attribute.getClass().getName()));
        }
        Object value = this.marshaller.write(attribute);
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            UUID newAttributeId = UUID.randomUUID();
            this.setNames(this.namesCache.compute(this.key, (BiFunction<NK, Map<String, UUID>, Map<String, UUID>>)(this.properties.isTransactional() ? new CopyOnWriteMapPutFunction((Object)name, (Object)newAttributeId) : new ConcurrentMapPutFunction((Object)name, (Object)newAttributeId))));
            attributeId = this.names.get(name);
        }
        K key = this.keyFactory.apply(attributeId);
        Object result = this.read(this.attributeCache.put(key, value));
        if (this.properties.isTransactional()) {
            this.mutations.put(attributeId, Mutator.PASSIVE);
        } else if (this.immutability.test(attribute)) {
            this.mutations.remove(attributeId);
        } else {
            this.mutations.put(attributeId, this.mutatorFactory.apply(key, value));
        }
        return result;
    }

    public Object getAttribute(String name) {
        UUID attributeId = this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        K key = this.keyFactory.apply(attributeId);
        V value = this.attributeCache.get(key);
        Object attribute = this.read(value);
        if (attribute != null && !this.immutability.test(attribute)) {
            this.mutations.putIfAbsent(attributeId, this.mutatorFactory.apply(key, value));
        }
        return attribute;
    }

    public Set<String> getAttributeNames() {
        return this.names.keySet();
    }

    @Override
    public void close() {
        for (Mutator mutator : this.mutations.values()) {
            mutator.mutate();
        }
        this.mutations.clear();
    }

    private void setNames(Map<String, UUID> names) {
        this.names = names != null ? Collections.unmodifiableMap(names) : Collections.emptyMap();
    }

    private Object read(V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw new IllegalStateException(e);
        }
    }
}

