/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;

public abstract class BaseDevice
implements Device {
    private static final Pattern A = Pattern.compile("^\\\\([0-9]{1,3})");
    private static final Pattern B = Pattern.compile("^\\\\x([0-9,A-F,a-f]{1,2})");

    @Override
    public int[] getStringCapabilityAsInts(Capability capability) {
        String str = this.getStringCapability(capability);
        if (str != null) {
            return BaseDevice.parseKeySeq(str);
        }
        return null;
    }

    @Override
    public boolean puts(Consumer<int[]> output, Capability capability) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        output.accept(BaseDevice.parseKeySeq(str));
        return true;
    }

    private static int[] parseKeySeq(String keyseq) {
        ArrayList<Integer> builder = new ArrayList<Integer>();
        while (keyseq.length() > 0) {
            if (keyseq.startsWith("\\C-") && keyseq.length() > 3) {
                int c = Character.toUpperCase(keyseq.charAt(3)) - 64 & 0x7F;
                builder.add(c);
                keyseq = keyseq.substring(4);
                continue;
            }
            if (keyseq.startsWith("\\M-") && keyseq.length() > 3) {
                int c = Character.toUpperCase(keyseq.charAt(3)) - 64 & 0x7F;
                builder.add(27);
                builder.add(c);
                keyseq = keyseq.substring(4);
                continue;
            }
            if (keyseq.startsWith("^") && keyseq.length() > 1) {
                int c = Character.toUpperCase(keyseq.charAt(1)) - 64 & 0x7F;
                builder.add(c);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\e") || keyseq.startsWith("\\E")) {
                builder.add(27);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\\\")) {
                builder.add(92);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\\"")) {
                builder.add(34);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\'")) {
                builder.add(39);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\a")) {
                builder.add(7);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\b")) {
                builder.add(8);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\d")) {
                builder.add(127);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\f")) {
                builder.add(12);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\n")) {
                builder.add(10);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\r")) {
                builder.add(13);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\t")) {
                builder.add(9);
                keyseq = keyseq.substring(2);
                continue;
            }
            if (keyseq.startsWith("\\v")) {
                builder.add(11);
                keyseq = keyseq.substring(2);
                continue;
            }
            Matcher matcher = A.matcher(keyseq);
            if (matcher.find()) {
                builder.add(Integer.parseInt(matcher.group(1), 8));
                keyseq = keyseq.substring(matcher.end());
                continue;
            }
            matcher = B.matcher(keyseq);
            if (matcher.find()) {
                builder.add(Integer.parseInt(matcher.group(1), 16));
                keyseq = keyseq.substring(matcher.end());
                continue;
            }
            builder.add(Integer.valueOf(keyseq.charAt(0)));
            keyseq = keyseq.substring(1);
        }
        int[] f = new int[builder.size()];
        for (int i = 0; i < builder.size(); ++i) {
            f[i] = (Integer)builder.get(i);
        }
        return f;
    }
}

