/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.blocktree.Lucene40BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.Lucene40IntersectTermsEnum;
import org.apache.lucene.codecs.blocktree.Lucene40SegmentTermsEnum;
import org.apache.lucene.codecs.blocktree.Lucene40Stats;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;

@Deprecated
final class Lucene40FieldReader
extends Terms
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene40FieldReader.class) + 3L * RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final BytesRef rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final int longsSize;
    final Lucene40BlockTreeTermsReader parent;
    final FST<BytesRef> index;

    Lucene40FieldReader(Lucene40BlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, BytesRef rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, int longsSize, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.indexStartFP = indexStartFP;
        this.rootCode = rootCode;
        this.longsSize = longsSize;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(rootCode.bytes, rootCode.offset, rootCode.length).readVLong() >>> 2;
        if (indexIn != null) {
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            this.index = new FST((DataInput)clone, (Outputs)ByteSequenceOutputs.getSingleton());
        } else {
            this.index = null;
        }
    }

    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    public Lucene40Stats getStats() throws IOException {
        return new Lucene40SegmentTermsEnum(this).computeBlockStats();
    }

    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    public TermsEnum iterator() throws IOException {
        return new Lucene40SegmentTermsEnum(this);
    }

    public long size() {
        return this.numTerms;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new Lucene40IntersectTermsEnum(this, compiled, startTerm);
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.index != null ? this.index.ramBytesUsed() : 0L);
    }

    public Collection<Accountable> getChildResources() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(Accountables.namedAccountable((String)"term index", this.index));
    }

    public String toString() {
        return "BlockTreeTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

