/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.OpenMetricsUnit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;

public class OpenMetricsExporter
implements Exporter {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final String MICROPROFILE_METRICS_OMIT_HELP_LINE = "microprofile.metrics.omitHelpLine";
    public static final String SMALLRYE_METRICS_USE_PREFIX_FOR_SCOPE = "smallrye.metrics.usePrefixForScope";
    private static final String LF = "\n";
    private static final String GAUGE = "gauge";
    private static final String SPACE = " ";
    private static final String SUMMARY = "summary";
    private static final String USCORE = "_";
    private static final String COUNTER = "counter";
    private static final String QUANTILE = "quantile";
    private static final String NONE = "none";
    private boolean writeHelpLine;
    private final boolean usePrefixForScope;
    private ThreadLocal<Set<String>> alreadyExportedNames = new ThreadLocal();

    public OpenMetricsExporter() {
        Config config = ConfigProvider.getConfig();
        Optional tmp = config.getOptionalValue(MICROPROFILE_METRICS_OMIT_HELP_LINE, Boolean.class);
        this.usePrefixForScope = config.getOptionalValue(SMALLRYE_METRICS_USE_PREFIX_FOR_SCOPE, Boolean.class).orElse(true);
        this.writeHelpLine = !tmp.isPresent() || (Boolean)tmp.get() == false;
    }

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        this.alreadyExportedNames.set(new HashSet());
        StringBuilder sb = new StringBuilder();
        this.getEntriesForScope(scope, sb);
        this.alreadyExportedNames.set(null);
        return sb;
    }

    @Override
    public StringBuilder exportAllScopes() {
        StringBuilder sb = new StringBuilder();
        for (MetricRegistry.Type scope : MetricRegistry.Type.values()) {
            this.alreadyExportedNames.set(new HashSet());
            this.getEntriesForScope(scope, sb);
            this.alreadyExportedNames.set(null);
        }
        return sb;
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        this.alreadyExportedNames.set(new HashSet());
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Metric m = (Metric)metricMap.get(metricID);
        HashMap<MetricID, Metric> outMap = new HashMap<MetricID, Metric>(1);
        outMap.put(metricID, m);
        StringBuilder sb = new StringBuilder();
        this.exposeEntries(scope, sb, registry, outMap);
        this.alreadyExportedNames.set(null);
        return sb;
    }

    @Override
    public StringBuilder exportMetricsByName(MetricRegistry.Type scope, String name) {
        this.alreadyExportedNames.set(new HashSet());
        MetricRegistry registry = MetricRegistries.get(scope);
        Map<MetricID, Metric> metricsToExport = registry.getMetrics().entrySet().stream().filter(entry -> ((MetricID)entry.getKey()).getName().equals(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        StringBuilder sb = new StringBuilder();
        this.exposeEntries(scope, sb, registry, metricsToExport);
        this.alreadyExportedNames.set(null);
        return sb;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    private void getEntriesForScope(MetricRegistry.Type scope, StringBuilder sb) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        this.exposeEntries(scope, sb, registry, metricMap);
    }

    private void exposeEntries(MetricRegistry.Type scope, StringBuilder sb, MetricRegistry registry, Map<MetricID, Metric> metricMap) {
        for (Map.Entry<MetricID, Metric> entry : metricMap.entrySet()) {
            String key = entry.getKey().getName();
            Metadata md = (Metadata)registry.getMetadata().get(key);
            if (md == null) {
                throw new IllegalStateException("No entry for " + key + " found");
            }
            Metric metric = entry.getValue();
            Map tagsMap = entry.getKey().getTags();
            StringBuilder metricBuf = new StringBuilder();
            try {
                switch (md.getTypeRaw()) {
                    case GAUGE: {
                        key = OpenMetricsExporter.getOpenMetricsMetricName(key);
                        String unitSuffix = null;
                        String unit = OpenMetricsUnit.getBaseUnitAsOpenMetricsString(md.getUnit());
                        if (!unit.equals(NONE)) {
                            unitSuffix = USCORE + unit;
                        }
                        this.writeHelpLine(metricBuf, scope, key, md, unitSuffix);
                        this.writeTypeLine(metricBuf, scope, key, md, unitSuffix, null);
                        this.createSimpleValueLine(metricBuf, scope, key, md, metric, null, tagsMap);
                        break;
                    }
                    case COUNTER: {
                        key = OpenMetricsExporter.getOpenMetricsMetricName(key);
                        String suffix = key.endsWith("_total") ? null : "_total";
                        this.writeHelpLine(metricBuf, scope, key, md, suffix);
                        this.writeTypeLine(metricBuf, scope, key, md, suffix, null);
                        this.createSimpleValueLine(metricBuf, scope, key, md, metric, suffix, tagsMap);
                        break;
                    }
                    case CONCURRENT_GAUGE: {
                        ConcurrentGauge concurrentGauge = (ConcurrentGauge)metric;
                        this.writeConcurrentGaugeValues(sb, scope, concurrentGauge, md, key, tagsMap);
                        break;
                    }
                    case METERED: {
                        Metered meter = (Metered)metric;
                        this.writeMeterValues(metricBuf, scope, meter, md, tagsMap);
                        break;
                    }
                    case TIMER: {
                        Timer timer = (Timer)metric;
                        this.writeTimerValues(metricBuf, scope, timer, md, tagsMap);
                        break;
                    }
                    case HISTOGRAM: {
                        Histogram histogram = (Histogram)metric;
                        this.writeHistogramValues(metricBuf, scope, histogram, md, tagsMap);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported: " + key);
                    }
                }
                sb.append((CharSequence)metricBuf);
                this.alreadyExportedNames.get().add(key);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to export metric " + key), (Throwable)e);
            }
        }
    }

    private void writeTimerValues(StringBuilder sb, MetricRegistry.Type scope, Timer timer, Metadata md, Map<String, String> tags) {
        String unit = OpenMetricsUnit.getBaseUnitAsOpenMetricsString(md.getUnit());
        if (unit.equals(NONE)) {
            unit = "seconds";
        }
        String theUnit = USCORE + unit;
        this.writeMeterRateValues(sb, scope, (Metered)timer, md, tags);
        Snapshot snapshot = timer.getSnapshot();
        this.writeSnapshotBasics(sb, scope, md, snapshot, theUnit, true, tags);
        this.writeHelpLine(sb, scope, md.getName(), md, theUnit);
        this.writeTypeLine(sb, scope, md.getName(), md, theUnit, SUMMARY);
        this.writeValueLine(sb, scope, theUnit + "_count", timer.getCount(), md, tags, false);
        this.writeSnapshotQuantiles(sb, scope, md, snapshot, theUnit, true, tags);
    }

    private void writeConcurrentGaugeValues(StringBuilder sb, MetricRegistry.Type scope, ConcurrentGauge concurrentGauge, Metadata md, String key, Map<String, String> tags) {
        key = OpenMetricsExporter.getOpenMetricsMetricName(key);
        this.writeHelpLine(sb, scope, key, md, "_current");
        this.writeTypeAndValue(sb, scope, "_current", concurrentGauge.getCount(), GAUGE, md, false, tags);
        this.writeTypeAndValue(sb, scope, "_max", concurrentGauge.getMax(), GAUGE, md, false, tags);
        this.writeTypeAndValue(sb, scope, "_min", concurrentGauge.getMin(), GAUGE, md, false, tags);
    }

    private void writeHistogramValues(StringBuilder sb, MetricRegistry.Type scope, Histogram histogram, Metadata md, Map<String, String> tags) {
        Snapshot snapshot = histogram.getSnapshot();
        Optional optUnit = md.getUnit();
        String unit = OpenMetricsUnit.getBaseUnitAsOpenMetricsString(optUnit);
        String theUnit = unit.equals(NONE) ? "" : USCORE + unit;
        this.writeHelpLine(sb, scope, md.getName(), md, theUnit);
        this.writeSnapshotBasics(sb, scope, md, snapshot, theUnit, true, tags);
        this.writeTypeLine(sb, scope, md.getName(), md, theUnit, SUMMARY);
        this.writeValueLine(sb, scope, theUnit + "_count", histogram.getCount(), md, tags, false);
        this.writeSnapshotQuantiles(sb, scope, md, snapshot, theUnit, true, tags);
    }

    private void writeSnapshotBasics(StringBuilder sb, MetricRegistry.Type scope, Metadata md, Snapshot snapshot, String unit, boolean performScaling, Map<String, String> tags) {
        this.writeTypeAndValue(sb, scope, "_min" + unit, snapshot.getMin(), GAUGE, md, performScaling, tags);
        this.writeTypeAndValue(sb, scope, "_max" + unit, snapshot.getMax(), GAUGE, md, performScaling, tags);
        this.writeTypeAndValue(sb, scope, "_mean" + unit, snapshot.getMean(), GAUGE, md, performScaling, tags);
        this.writeTypeAndValue(sb, scope, "_stddev" + unit, snapshot.getStdDev(), GAUGE, md, performScaling, tags);
    }

    private void writeSnapshotQuantiles(StringBuilder sb, MetricRegistry.Type scope, Metadata md, Snapshot snapshot, String unit, boolean performScaling, Map<String, String> tags) {
        Map<String, String> map = this.copyMap(tags);
        map.put(QUANTILE, "0.5");
        this.writeValueLine(sb, scope, unit, snapshot.getMedian(), md, map, performScaling);
        map.put(QUANTILE, "0.75");
        this.writeValueLine(sb, scope, unit, snapshot.get75thPercentile(), md, map, performScaling);
        map.put(QUANTILE, "0.95");
        this.writeValueLine(sb, scope, unit, snapshot.get95thPercentile(), md, map, performScaling);
        map.put(QUANTILE, "0.98");
        this.writeValueLine(sb, scope, unit, snapshot.get98thPercentile(), md, map, performScaling);
        map.put(QUANTILE, "0.99");
        this.writeValueLine(sb, scope, unit, snapshot.get99thPercentile(), md, map, performScaling);
        map.put(QUANTILE, "0.999");
        this.writeValueLine(sb, scope, unit, snapshot.get999thPercentile(), md, map, performScaling);
    }

    private void writeMeterValues(StringBuilder sb, MetricRegistry.Type scope, Metered metric, Metadata md, Map<String, String> tags) {
        this.writeHelpLine(sb, scope, md.getName(), md, "_total");
        this.writeTypeAndValue(sb, scope, "_total", metric.getCount(), COUNTER, md, false, tags);
        this.writeMeterRateValues(sb, scope, metric, md, tags);
    }

    private void writeMeterRateValues(StringBuilder sb, MetricRegistry.Type scope, Metered metric, Metadata md, Map<String, String> tags) {
        this.writeTypeAndValue(sb, scope, "_rate_per_second", metric.getMeanRate(), GAUGE, md, false, tags);
        this.writeTypeAndValue(sb, scope, "_one_min_rate_per_second", metric.getOneMinuteRate(), GAUGE, md, false, tags);
        this.writeTypeAndValue(sb, scope, "_five_min_rate_per_second", metric.getFiveMinuteRate(), GAUGE, md, false, tags);
        this.writeTypeAndValue(sb, scope, "_fifteen_min_rate_per_second", metric.getFifteenMinuteRate(), GAUGE, md, false, tags);
    }

    private void writeTypeAndValue(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, String type, Metadata md, boolean performScaling, Map<String, String> tags) {
        String key = md.getName();
        this.writeTypeLine(sb, scope, key, md, suffix, type);
        this.writeValueLine(sb, scope, suffix, valueRaw, md, tags, performScaling);
    }

    private void writeValueLine(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, Metadata md) {
        this.writeValueLine(sb, scope, suffix, valueRaw, md, null);
    }

    private void writeValueLine(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, Metadata md, Map<String, String> tags) {
        this.writeValueLine(sb, scope, suffix, valueRaw, md, tags, true);
    }

    private void writeValueLine(StringBuilder sb, MetricRegistry.Type scope, String suffix, double valueRaw, Metadata md, Map<String, String> tags, boolean performScaling) {
        Double value;
        String name = md.getName();
        name = OpenMetricsExporter.getOpenMetricsMetricName(name);
        this.fillBaseName(sb, scope, name, suffix);
        if (tags != null) {
            this.addTags(sb, tags, scope);
        }
        sb.append(SPACE);
        if (performScaling) {
            String scaleFrom = "nanoseconds";
            if (md.getTypeRaw() == MetricType.HISTOGRAM) {
                scaleFrom = md.getUnit().orElse(NONE);
            }
            value = OpenMetricsUnit.scaleToBase(scaleFrom, valueRaw);
        } else {
            value = valueRaw;
        }
        sb.append(value).append(LF);
    }

    private void addTags(StringBuilder sb, Map<String, String> tags, MetricRegistry.Type scope) {
        if (tags == null || tags.isEmpty()) {
            if (!this.usePrefixForScope) {
                sb.append("{microprofile_scope=\"" + scope.getName().toLowerCase() + "\"}");
            }
            return;
        }
        Iterator<Map.Entry<String, String>> iter = tags.entrySet().iterator();
        sb.append("{");
        while (iter.hasNext()) {
            Map.Entry<String, String> tag = iter.next();
            sb.append(tag.getKey()).append("=\"").append(OpenMetricsExporter.quoteValue(tag.getValue())).append("\"");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        if (!this.usePrefixForScope) {
            sb.append(",microprofile_scope=\"" + scope.getName().toLowerCase() + "\"");
        }
        sb.append("}");
    }

    private <K, V> Map<K, V> copyMap(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void fillBaseName(StringBuilder sb, MetricRegistry.Type scope, String key, String suffix) {
        if (this.usePrefixForScope) {
            sb.append(scope.getName().toLowerCase()).append(USCORE);
        }
        sb.append(key);
        if (suffix != null) {
            sb.append(suffix);
        }
    }

    private void writeHelpLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, String suffix) {
        if (this.writeHelpLine && !md.getDescription().orElse("").isEmpty() && !this.alreadyExportedNames.get().contains(md.getName())) {
            sb.append("# HELP ");
            this.getNameWithScopeAndSuffix(sb, scope, key, suffix);
            sb.append(OpenMetricsExporter.quoteHelpText((String)md.getDescription().get()));
            sb.append(LF);
        }
    }

    private void writeTypeLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, String suffix, String typeOverride) {
        if (!this.alreadyExportedNames.get().contains(md.getName())) {
            sb.append("# TYPE ");
            this.getNameWithScopeAndSuffix(sb, scope, key, suffix);
            if (typeOverride != null) {
                sb.append(typeOverride);
            } else if (md.getTypeRaw().equals((Object)MetricType.TIMER)) {
                sb.append(SUMMARY);
            } else if (md.getTypeRaw().equals((Object)MetricType.METERED)) {
                sb.append(COUNTER);
            } else {
                sb.append(md.getType());
            }
            sb.append(LF);
        }
    }

    private void getNameWithScopeAndSuffix(StringBuilder sb, MetricRegistry.Type scope, String key, String suffix) {
        if (this.usePrefixForScope) {
            sb.append(scope.getName().toLowerCase()).append('_');
        }
        sb.append(OpenMetricsExporter.getOpenMetricsMetricName(key));
        if (suffix != null) {
            sb.append(suffix);
        }
        sb.append(SPACE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createSimpleValueLine(StringBuilder sb, MetricRegistry.Type scope, String key, Metadata md, Metric metric, String suffix, Map<String, String> tags) {
        double valIn;
        this.fillBaseName(sb, scope, key, suffix);
        String unit = OpenMetricsUnit.getBaseUnitAsOpenMetricsString(md.getUnit());
        if (!unit.equals(NONE)) {
            sb.append(USCORE).append(unit);
        }
        this.addTags(sb, tags, scope);
        if (md.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            Number value1 = (Number)((Gauge)metric).getValue();
            if (value1 == null) {
                log.warn((Object)("Value is null for " + key));
                throw new IllegalStateException("Value must not be null for " + key);
            }
            valIn = value1.doubleValue();
        } else {
            valIn = ((Counter)metric).getCount();
        }
        Double value = OpenMetricsUnit.scaleToBase(md.getUnit().orElse(NONE), valIn);
        sb.append(SPACE).append(value).append(LF);
    }

    static String getOpenMetricsMetricName(String name) {
        String out = name.replaceAll("[^\\w]+", USCORE);
        out = out.replace("__", USCORE);
        out = out.replace(":_", ":");
        return out;
    }

    public static String quoteHelpText(String value) {
        return value.replaceAll("\\\\([^n])", "\\\\\\\\$1").replaceAll("\\\\$", "\\\\\\\\");
    }

    public static String quoteValue(String value) {
        return value.replaceAll("\\\\([^n])", "\\\\\\\\$1").replaceAll("\"", "\\\\\"").replaceAll("\\\\$", "\\\\\\\\");
    }
}

