/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.ServletStackTraces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.CrawlerSessionManagementDefinition;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.MimeMappingDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServletContainerAdd;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.WelcomeFileDefinition;

class ServletContainerDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> SERVLET_CONTAINER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.servlet-container", (boolean)true, ServletContainerService.class).addRequirements(new String[]{"org.wildfly.undertow"}).build();
    protected static final SimpleAttributeDefinition ALLOW_NON_STANDARD_WRAPPERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allow-non-standard-wrappers", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DEFAULT_BUFFER_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-buffer-cache", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode("default"))).build();
    protected static final SimpleAttributeDefinition STACK_TRACE_ON_ERROR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("stack-trace-on-error", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(ServletStackTraces.LOCAL_ONLY.toString()))).setValidator((ParameterValidator)new EnumValidator(ServletStackTraces.class, true, true))).setAllowExpression(true)).build();
    protected static final SimpleAttributeDefinition DEFAULT_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-encoding", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final AttributeDefinition USE_LISTENER_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-listener-encoding", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final AttributeDefinition IGNORE_FLUSH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ignore-flush", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final AttributeDefinition EAGER_FILTER_INIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("eager-filter-initialization", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    protected static final AttributeDefinition DEFAULT_SESSION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-session-timeout", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MINUTES)).setDefaultValue(new ModelNode(30))).build();
    protected static final AttributeDefinition DISABLE_CACHING_FOR_SECURED_PAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disable-caching-for-secured-pages", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    protected static final AttributeDefinition DIRECTORY_LISTING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("directory-listing", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final AttributeDefinition PROACTIVE_AUTHENTICATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proactive-authentication", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).build();
    protected static final AttributeDefinition SESSION_ID_LENGTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-id-length", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(16, 200, true, true))).setDefaultValue(new ModelNode(30))).build();
    protected static final AttributeDefinition MAX_SESSIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-sessions", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final AttributeDefinition DISABLE_FILE_WATCH_SERVICE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disable-file-watch-service", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final AttributeDefinition DISABLE_SESSION_ID_REUSE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disable-session-id-reuse", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    protected static final AttributeDefinition FILE_CACHE_METADATA_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("file-cache-metadata-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(100))).setAllowExpression(true)).build();
    protected static final AttributeDefinition FILE_CACHE_MAX_FILE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("file-cache-max-file-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(0xA00000))).setAllowExpression(true)).build();
    protected static final AttributeDefinition FILE_CACHE_TIME_TO_LIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("file-cache-time-to-live", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final AttributeDefinition DEFAULT_COOKIE_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-cookie-version", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setValidator((ParameterValidator)new IntRangeValidator(0, 1, true, true))).build();
    private static final List<? extends PersistentResourceDefinition> CHILDREN;
    static final Collection<AttributeDefinition> ATTRIBUTES;
    static final ServletContainerDefinition INSTANCE;

    private ServletContainerDefinition() {
        super(new SimpleResourceDefinition.Parameters(UndertowExtension.PATH_SERVLET_CONTAINER, (ResourceDescriptionResolver)UndertowExtension.getResolver("servlet-container")).setAddHandler((OperationStepHandler)ServletContainerAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).addCapabilities(new RuntimeCapability[]{SERVLET_CONTAINER_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public List<? extends PersistentResourceDefinition> getChildren() {
        return CHILDREN;
    }

    static {
        ATTRIBUTES = Arrays.asList(ALLOW_NON_STANDARD_WRAPPERS, DEFAULT_BUFFER_CACHE, STACK_TRACE_ON_ERROR, DEFAULT_ENCODING, USE_LISTENER_ENCODING, IGNORE_FLUSH, EAGER_FILTER_INIT, DEFAULT_SESSION_TIMEOUT, DISABLE_CACHING_FOR_SECURED_PAGES, DIRECTORY_LISTING, PROACTIVE_AUTHENTICATION, SESSION_ID_LENGTH, MAX_SESSIONS, DISABLE_FILE_WATCH_SERVICE, DISABLE_SESSION_ID_REUSE, FILE_CACHE_METADATA_SIZE, FILE_CACHE_MAX_FILE_SIZE, FILE_CACHE_TIME_TO_LIVE, DEFAULT_COOKIE_VERSION);
        INSTANCE = new ServletContainerDefinition();
        ArrayList<PersistentResourceDefinition> children = new ArrayList<PersistentResourceDefinition>();
        children.add(JspDefinition.INSTANCE);
        children.add(SessionCookieDefinition.INSTANCE);
        children.add(PersistentSessionsDefinition.INSTANCE);
        children.add(WebsocketsDefinition.INSTANCE);
        children.add(MimeMappingDefinition.INSTANCE);
        children.add(WelcomeFileDefinition.INSTANCE);
        children.add(CrawlerSessionManagementDefinition.INSTANCE);
        CHILDREN = Collections.unmodifiableList(children);
    }
}

