/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.function.Functions;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.server.dispatcher.AutoCloseableCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.ManagedCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.MarshallingConfigurationContext;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class ChannelCommandDispatcherFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
ChannelCommandDispatcherFactoryConfiguration,
MarshallingConfigurationContext,
Supplier<AutoCloseableCommandDispatcherFactory> {
    private final String group;
    private volatile SupplierDependency<ChannelFactory> channelFactory;
    private volatile SupplierDependency<JChannel> channel;
    private volatile SupplierDependency<Module> module;
    private volatile Supplier<ModuleLoader> loader;
    private volatile Duration timeout = Duration.ofMinutes(1L);

    public ChannelCommandDispatcherFactoryServiceConfigurator(ServiceName name, String group) {
        super(name);
        this.group = group;
    }

    @Override
    public AutoCloseableCommandDispatcherFactory get() {
        return new ManagedCommandDispatcherFactory(new ChannelCommandDispatcherFactory(this));
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.channel = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL.getServiceName(support, this.group));
        this.channelFactory = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(support, this.group));
        this.module = new ServiceSupplierDependency(JGroupsRequirement.CHANNEL_MODULE.getServiceName(support, this.group));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).build(target);
        this.loader = builder.requires(Services.JBOSS_SERVICE_MODULE_LOADER);
        Consumer factory = new CompositeDependency(new Dependency[]{this.channel, this.channelFactory, this.module}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, Functions.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    public ChannelCommandDispatcherFactoryServiceConfigurator timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public Module getModule() {
        return (Module)this.module.get();
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this.loader.get();
    }

    @Override
    public JChannel getChannel() {
        return (JChannel)this.channel.get();
    }

    @Override
    public MarshallingContext getMarshallingContext() {
        return new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this), (ClassLoader)this.getModule().getClassLoader());
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.channelFactory.get();
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)context.getModule().getClassLoader()));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

