/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StabilityMonitor;
import org.wildfly.clustering.service.PrivilegedActionSupplier;

public class ServiceSupplier<T>
implements Supplier<T> {
    private final Supplier<ServiceController<?>> factory;
    private final ServiceController.Mode mode;
    private volatile Duration duration = null;

    ServiceSupplier(final ServiceRegistry registry, final ServiceName name, ServiceController.Mode mode) {
        this.factory = new PrivilegedActionSupplier<ServiceController<?>>(){

            @Override
            public ServiceController<?> run() {
                return registry.getRequiredService(name);
            }
        };
        this.mode = mode;
    }

    public ServiceSupplier<T> setTimeout(Duration duration) {
        this.duration = duration;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get() {
        ServiceController<?> sourceController = this.factory.get();
        ServiceName sourceName = sourceController.getName();
        ServiceContainer target = sourceController.getServiceContainer();
        ServiceName name = sourceName.append(new String[]{UUID.randomUUID().toString()});
        ServiceBuilder builder = target.addService(name);
        Supplier supplier = builder.requires(sourceName);
        ServiceController controller = builder.setInitialMode(this.mode).install();
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            Duration duration = this.duration;
            if (duration == null) {
                monitor.awaitStability();
            } else if (!monitor.awaitStability(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException(new TimeoutException());
            }
            switch (controller.getState()) {
                case START_FAILED: {
                    throw new IllegalStateException(controller.getStartException());
                }
                case UP: {
                    Object t = supplier.get();
                    return t;
                }
            }
            T t = null;
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        finally {
            controller.setMode(ServiceController.Mode.REMOVE);
            try {
                monitor.awaitStability();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                monitor.removeController(controller);
            }
        }
    }
}

