/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.function.Consumer;
import org.jboss.msc.service.ServiceController;

final class WritableValueImpl
implements Consumer<Object> {
    private static final Object UNDEFINED = new Object();
    private volatile ServiceController controller;
    volatile Object value = UNDEFINED;

    WritableValueImpl() {
    }

    Object getValue() {
        if (UNDEFINED != this.value) {
            return this.value;
        }
        throw new IllegalStateException("Service unavailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Object newValue) {
        ServiceController controller = this.controller;
        if (controller != null) {
            ServiceController serviceController = controller;
            synchronized (serviceController) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.STARTING) {
                    this.value = newValue;
                    return;
                }
                if (state == ServiceController.State.STOPPING) {
                    if (newValue != null) {
                        throw new IllegalArgumentException("Null parameter expected");
                    }
                    this.value = UNDEFINED;
                    return;
                }
            }
        }
        throw new IllegalStateException("Outside of Service lifecycle method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninject() {
        ServiceController controller = this.controller;
        if (controller != null) {
            ServiceController serviceController = controller;
            synchronized (serviceController) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.STARTING || state == ServiceController.State.STOPPING) {
                    this.value = UNDEFINED;
                    return;
                }
            }
        }
        throw new IllegalStateException("Outside of Service lifecycle method");
    }

    void setInstance(ServiceController controller) {
        this.controller = controller;
    }
}

