/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.MetricsHandler;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.deployment.UndertowMetricsCollector;

public class DeploymentServletDefinition
extends SimpleResourceDefinition {
    public static final DeploymentServletDefinition INSTANCE = new DeploymentServletDefinition();
    static final SimpleAttributeDefinition SERVLET_NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("servlet-name", ModelType.STRING, false).setStorageRuntime()).build();
    static final SimpleAttributeDefinition SERVLET_CLASS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("servlet-class", ModelType.STRING, false).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition MIN_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("min-request-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setStorageRuntime()).build();
    static final SimpleAttributeDefinition TOTAL_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("total-request-time", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build();
    static final SimpleAttributeDefinition REQUEST_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-count", ModelType.LONG).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build();
    static final SimpleListAttributeDefinition SERVLET_MAPPINGS = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("mappings", (AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("mapping", ModelType.STRING).setRequired(false)).build()).setRequired(false)).setStorageRuntime()).build();

    private DeploymentServletDefinition() {
        super(PathElement.pathElement((String)"servlet"), (ResourceDescriptionResolver)UndertowExtension.getResolver("deployment.servlet"));
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        registration.registerReadOnlyAttribute((AttributeDefinition)SERVLET_NAME, null);
        registration.registerReadOnlyAttribute((AttributeDefinition)SERVLET_CLASS, null);
        registration.registerMetric((AttributeDefinition)MAX_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, MetricsHandler.MetricResult metricResult) {
                response.set((long)metricResult.getMaxRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MIN_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, MetricsHandler.MetricResult metricResult) {
                response.set((long)metricResult.getMinRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)TOTAL_REQUEST_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getTotalRequestTime());
            }
        });
        registration.registerMetric((AttributeDefinition)REQUEST_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, MetricsHandler.MetricResult metricResult) {
                response.set(metricResult.getTotalRequests());
            }
        });
        registration.registerReadOnlyAttribute((AttributeDefinition)SERVLET_MAPPINGS, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                Resource web = context.readResourceFromRoot(address.subAddress(0, address.size() - 1), false);
                ModelNode subModel = web.getModel();
                final String host = DeploymentDefinition.VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
                final String path = DeploymentDefinition.CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
                final String server = DeploymentDefinition.SERVER.resolveModelAttribute(context, subModel).asString();
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) {
                        ServiceController deploymentServiceController = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
                        if (deploymentServiceController == null || deploymentServiceController.getState() != ServiceController.State.UP) {
                            return;
                        }
                        UndertowDeploymentService deploymentService = (UndertowDeploymentService)deploymentServiceController.getService();
                        DeploymentInfo deploymentInfo = (DeploymentInfo)deploymentService.getDeploymentInfoInjectedValue().getValue();
                        ServletInfo servlet = (ServletInfo)deploymentInfo.getServlets().get(context.getCurrentAddressValue());
                        ModelNode response = new ModelNode();
                        response.setEmptyList();
                        for (String mapping : servlet.getMappings()) {
                            response.add(mapping);
                        }
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        });
    }

    static abstract class AbstractMetricsHandler
    implements OperationStepHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, MetricsHandler.MetricResult var2);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size() - 1), false);
            ModelNode subModel = web.getModel();
            final String host = DeploymentDefinition.VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            final String path = DeploymentDefinition.CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            final String server = DeploymentDefinition.SERVER.resolveModelAttribute(context, subModel).asString();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    MetricsHandler.MetricResult result;
                    ServiceController deploymentServiceController = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
                    if (deploymentServiceController == null || deploymentServiceController.getState() != ServiceController.State.UP) {
                        return;
                    }
                    UndertowDeploymentService deploymentService = (UndertowDeploymentService)deploymentServiceController.getService();
                    DeploymentInfo deploymentInfo = (DeploymentInfo)deploymentService.getDeploymentInfoInjectedValue().getValue();
                    UndertowMetricsCollector collector = (UndertowMetricsCollector)deploymentInfo.getMetricsCollector();
                    MetricsHandler.MetricResult metricResult = result = collector != null ? collector.getMetrics(context.getCurrentAddressValue()) : null;
                    if (result != null) {
                        ModelNode response = new ModelNode();
                        this.handle(response, result);
                        context.getResult().set(response);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

