/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.IndexedTypeIdentifierFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BaseHibernateSearchLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serializationProtocol = "HSEARCH000079: Serialization protocol version %1$d.%2$d initialized";
    private static final String incompatibleProtocolVersion = "HSEARCH000098: Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d";
    private static final String unableToLoadAvroSchema = "HSEARCH300001: Unable to find Avro schema '%s'";
    private static final String unexpectedMinorProtocolVersion = "HSEARCH300002: Parsing message from a future protocol version. Some feature might not be propagated. Message version: %1$d.%2$d. Current protocol version: %1$d.%3$d";
    private static final String interruptedWhileWaitingForIndexActivity = "HSEARCH000049: '%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String illegalObjectRetrievedFromMessage = "HSEARCH000069: Illegal object retrieved from message";
    private static final String unableToLoadResource = "HSEARCH000114: Could not load resource: '%1$s'";
    private static final String unknownResolution = "HSEARCH000140: Unknown Resolution: %1$s";
    private static final String unsupportedFacetRangeParameter = "HSEARCH000266: '%s' is not a valid type for a facet range request. Numbers (byte, short, int, long, float, double and their wrappers) as well as dates are supported";
    private static final String projectingFieldWithoutTwoWayFieldBridge = "HSEARCH000324: The fieldBridge for field '%1$s' is an instance of '%2$s', which does not implement TwoWayFieldBridge. Projected fields must have a TwoWayFieldBridge.";
    private static final String unsupportedNullTokenType = "HSEARCH000327: Unsupported indexNullAs token type '%3$s' on field '%2$s' of entity '%1$s'.";
    private static final String invalidLuceneAnalyzerDefinitionProvider = "HSEARCH000329: Property 'hibernate.search.lucene.analysis_definition_provider' set to value '%1$s' is invalid. The value must be the fully-qualified name of a class with a public, no-arg constructor in your classpath. Also, the class must either implement LuceneAnalyzerDefinitionProvider or expose a public, @Factory-annotated method returning a LuceneAnalyzerDefinitionProvider.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serializationProtocol(int major, int minor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.serializationProtocol$str(), (Object)major, (Object)minor);
    }

    protected String serializationProtocol$str() {
        return serializationProtocol;
    }

    protected String incompatibleProtocolVersion$str() {
        return incompatibleProtocolVersion;
    }

    @Override
    public final SearchException incompatibleProtocolVersion(int messageMajor, int messageMinor, int currentMajor, int currentMinor) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleProtocolVersion$str(), messageMajor, messageMinor, currentMajor, currentMinor));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadAvroSchema$str() {
        return unableToLoadAvroSchema;
    }

    @Override
    public final SearchException unableToLoadAvroSchema(String avroSchemaFile) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadAvroSchema$str(), avroSchemaFile));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unexpectedMinorProtocolVersion(int majorVersion, int minorVersion, int latestKnownMinor) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unexpectedMinorProtocolVersion$str(), (Object)majorVersion, (Object)minorVersion, (Object)latestKnownMinor);
    }

    protected String unexpectedMinorProtocolVersion$str() {
        return unexpectedMinorProtocolVersion;
    }

    public final void interruptedWhileWaitingForIndexActivity(String arg0, InterruptedException arg1) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)arg1, this.interruptedWhileWaitingForIndexActivity$str(), (Object)arg0);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    public final void illegalObjectRetrievedFromMessage(Exception arg0) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)arg0, this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    public final SearchException unableToLoadResource(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToLoadResource$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    public final AssertionFailure unknownResolution(String arg0) {
        AssertionFailure result = new AssertionFailure(String.format(this.getLoggingLocale(), this.unknownResolution$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFacetRangeParameter$str() {
        return unsupportedFacetRangeParameter;
    }

    public final SearchException unsupportedFacetRangeParameter(String arg0) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedFacetRangeParameter$str(), arg0));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String projectingFieldWithoutTwoWayFieldBridge$str() {
        return projectingFieldWithoutTwoWayFieldBridge;
    }

    public final SearchException projectingFieldWithoutTwoWayFieldBridge(String arg0, Class<?> arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.projectingFieldWithoutTwoWayFieldBridge$str(), arg0, arg1));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedNullTokenType$str() {
        return unsupportedNullTokenType;
    }

    public final SearchException unsupportedNullTokenType(IndexedTypeIdentifier arg0, String arg1, Class<?> arg2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedNullTokenType$str(), new IndexedTypeIdentifierFormatter(arg0), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLuceneAnalyzerDefinitionProvider$str() {
        return invalidLuceneAnalyzerDefinitionProvider;
    }

    public final SearchException invalidLuceneAnalyzerDefinitionProvider(String arg0, Exception arg1) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLuceneAnalyzerDefinitionProvider$str(), arg0), (Throwable)arg1);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

