/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.servlet.AbsoluteOrderingMetaDataParser;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.TaglibMetaDataParser;
import org.jboss.metadata.parser.servlet.Version;
import org.jboss.metadata.parser.servlet.WebCommonMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebMetaDataParser
extends MetaDataElementParser {
    public static WebMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return WebMetaDataParser.parse(reader, info, false, propertyReplacer);
    }

    public static WebMetaData parse(XMLStreamReader reader, MetaDataElementParser.DTDInfo info, boolean validation, PropertyReplacer propertyReplacer) throws XMLStreamException {
        Attribute attribute;
        if (reader == null) {
            throw new IllegalArgumentException("Null reader");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null info");
        }
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        String schemaLocation = WebMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        Version version = null;
        if (info.getPublicID() != null) {
            version = Version.fromPublicID(info.getPublicID());
        }
        if (version == null && info.getSystemID() != null) {
            version = Version.fromSystemID(info.getSystemID());
        }
        if (version == null && schemaLocation != null) {
            version = Version.fromSystemID(schemaLocation);
        }
        WebMetaData wmd = new WebMetaData();
        if (version == null) {
            String versionString = null;
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (WebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("2.4".equals(versionString)) {
                version = Version.SERVLET_2_4;
            } else if ("2.5".equals(versionString)) {
                version = Version.SERVLET_2_5;
            } else if ("3.0".equals(versionString)) {
                version = Version.SERVLET_3_0;
            } else if ("3.1".equals(versionString)) {
                version = Version.SERVLET_3_1;
            } else if ("4.0".equals(versionString)) {
                version = Version.SERVLET_4_0;
            }
        }
        if (version != null) {
            wmd.setVersion(version.versionString());
        }
        if (info != null) {
            wmd.setDTD(info.getBaseURI(), info.getPublicID(), info.getSystemID());
        }
        if (schemaLocation != null) {
            wmd.setSchemaLocation(schemaLocation);
        }
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (WebMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    wmd.setId(value);
                    continue block16;
                }
                case VERSION: {
                    wmd.setVersion(value);
                    continue block16;
                }
                case METADATA_COMPLETE: {
                    if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block16;
                    wmd.setMetadataComplete(true);
                    continue block16;
                }
                default: {
                    throw WebMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            if (WebCommonMetaDataParser.parse(reader, wmd, propertyReplacer)) continue;
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env, (PropertyReplacer)propertyReplacer)) {
                if (wmd.getJndiEnvironmentRefsGroup() != null) continue;
                wmd.setJndiEnvironmentRefsGroup(env);
                continue;
            }
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (wmd.getDescriptionGroup() != null) continue;
                wmd.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ABSOLUTE_ORDERING: {
                    wmd.setAbsoluteOrdering(AbsoluteOrderingMetaDataParser.parse(reader, propertyReplacer));
                    continue block17;
                }
                case MODULE_NAME: {
                    wmd.setModuleName(WebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case TAGLIB: {
                    List<TaglibMetaData> taglibs;
                    JspConfigMetaData jspConfig = wmd.getJspConfig();
                    if (jspConfig == null) {
                        jspConfig = new JspConfigMetaData();
                        wmd.setJspConfig(jspConfig);
                    }
                    if ((taglibs = jspConfig.getTaglibs()) == null) {
                        taglibs = new ArrayList<TaglibMetaData>();
                        jspConfig.setTaglibs(taglibs);
                    }
                    taglibs.add(TaglibMetaDataParser.parse(reader, propertyReplacer));
                    continue block17;
                }
                case DENY_UNCOVERED_HTTP_METHODS: {
                    wmd.setDenyUncoveredHttpMethods(Boolean.parseBoolean(WebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                    continue block17;
                }
                case DEFAULT_CONTEXT_PATH: {
                    wmd.setDefaultContextPath(WebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case REQUEST_CHARACTER_ENCODING: {
                    wmd.setRequestCharacterEncoding(WebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case RESPONSE_CHARACTER_ENCODING: {
                    wmd.setResponseCharacterEncoding(WebMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
            }
            throw WebMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return wmd;
    }
}

