/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class ExpiredSessionRemover<MV, AV, L>
implements Remover<String>,
Registrar<SessionExpirationListener> {
    private final SessionFactory<MV, AV, L> factory;
    private final Collection<SessionExpirationListener> listeners = new CopyOnWriteArraySet<SessionExpirationListener>();

    public ExpiredSessionRemover(SessionFactory<MV, AV, L> factory) {
        this.factory = factory;
    }

    public boolean remove(String id) {
        ImmutableSessionMetaData metaData;
        Object metaDataValue = this.factory.getMetaDataFactory().tryValue((Object)id);
        if (metaDataValue != null && (metaData = this.factory.getMetaDataFactory().createImmutableSessionMetaData(id, metaDataValue)).isExpired()) {
            Object attributesValue = this.factory.getAttributesFactory().findValue((Object)id);
            if (attributesValue != null) {
                ImmutableSessionAttributes attributes = this.factory.getAttributesFactory().createImmutableSessionAttributes(id, attributesValue);
                ImmutableSession session = this.factory.createImmutableSession(id, metaData, attributes);
                InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s has expired.", id);
                for (SessionExpirationListener listener : this.listeners) {
                    listener.sessionExpired(session);
                }
            }
            return this.factory.remove((Object)id);
        }
        return false;
    }

    public Registration register(SessionExpirationListener listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }
}

