/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld._private.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadata;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.PropertyReplacingBeansXmlParser;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.processors.UrlScanner;
import org.jboss.as.weld.deployment.processors.WeldDeploymentProcessor;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.spi.ComponentSupport;
import org.jboss.as.weld.spi.ModuleServicesProvider;
import org.jboss.as.weld.util.Reflections;
import org.jboss.as.weld.util.ServiceLoaders;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.Indexer;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.xml.BeansXmlParser;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalBeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String META_INF_JANDEX_IDX = "META-INF/jandex.idx";
    private final String ALL_KNOWN_CLASSES = "ALL_KNOWN_CLASSES";
    private final String BEAN_CLASSES = "BEAN_CLASSES";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            return;
        }
        HashSet<String> componentClassNames = new HashSet<String>();
        ServiceLoader<ComponentSupport> supportServices = ServiceLoader.load(ComponentSupport.class, WildFlySecurityManager.getClassLoaderPrivileged(ExternalBeanArchiveProcessor.class));
        String beanArchiveIdPrefix = deploymentUnit.getName() + ".external.";
        HashSet<AnnotationType> beanDefiningAnnotations = new HashSet<AnnotationType>((Collection)deploymentUnit.getAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS));
        ArrayList<DeploymentUnit> deploymentUnits = new ArrayList<DeploymentUnit>();
        deploymentUnits.add(deploymentUnit);
        deploymentUnits.addAll(deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS));
        PropertyReplacingBeansXmlParser parser = new PropertyReplacingBeansXmlParser(deploymentUnit);
        HashSet<URL> existing = new HashSet<URL>();
        for (DeploymentUnit deployment : deploymentUnits) {
            try {
                ExplicitBeanArchiveMetadataContainer weldDeploymentMetadata = (ExplicitBeanArchiveMetadataContainer)deployment.getAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
                if (weldDeploymentMetadata != null) {
                    for (ExplicitBeanArchiveMetadata md : weldDeploymentMetadata.getBeanArchiveMetadata().values()) {
                        existing.add(md.getBeansXmlFile().toURL());
                        if (md.getAdditionalBeansXmlFile() == null) continue;
                        existing.add(md.getAdditionalBeansXmlFile().toURL());
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            EEModuleDescription moduleDesc = (EEModuleDescription)deployment.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            if (moduleDesc == null) continue;
            block4: for (ComponentDescription component : moduleDesc.getComponentDescriptions()) {
                for (ComponentSupport support : supportServices) {
                    if (support.isDiscoveredExternalType(component)) continue;
                    componentClassNames.add(component.getComponentClassName());
                    continue block4;
                }
            }
        }
        ServiceLoader<ModuleServicesProvider> moduleServicesProviders = ServiceLoader.load(ModuleServicesProvider.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldDeploymentProcessor.class));
        for (DeploymentUnit deployment : deploymentUnits) {
            Module module = (Module)deployment.getAttachment(Attachments.MODULE);
            if (module == null) {
                return;
            }
            for (DependencySpec dep : module.getDependencies()) {
                Map<URL, URL> resourcesMap;
                Module dependency = this.loadModuleDependency(dep);
                if (dependency == null || (resourcesMap = this.findExportedResources(dependency)).isEmpty()) continue;
                ArrayList<BeanDeploymentArchiveImpl> moduleBdas = new ArrayList<BeanDeploymentArchiveImpl>();
                for (Map.Entry<URL, URL> entry : resourcesMap.entrySet()) {
                    URL beansXmlUrl = entry.getKey();
                    if (existing.contains(beansXmlUrl) || beansXmlUrl.toString().contains("jsf-impl-2.2") || beansXmlUrl.toString().contains("resteasy-cdi")) continue;
                    WeldLogger.DEPLOYMENT_LOGGER.debugf("Found external beans.xml: %s", (Object)beansXmlUrl.toString());
                    BeansXml beansXml = this.parseBeansXml(beansXmlUrl, parser, deploymentUnit);
                    if (BeanDiscoveryMode.NONE.equals((Object)beansXml.getBeanDiscoveryMode())) continue;
                    Map<String, List<String>> allAndBeanClasses = this.discover(beansXml.getBeanDiscoveryMode(), beansXmlUrl, entry.getValue(), beanDefiningAnnotations);
                    Collection discoveredBeanClasses = allAndBeanClasses.get("BEAN_CLASSES");
                    Collection allKnownClasses = allAndBeanClasses.get("ALL_KNOWN_CLASSES");
                    if (discoveredBeanClasses == null) continue;
                    discoveredBeanClasses.removeAll(componentClassNames);
                    BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(new HashSet<String>(discoveredBeanClasses), new HashSet<String>(allKnownClasses), beansXml, dependency, beanArchiveIdPrefix + beansXmlUrl.toExternalForm(), BeanDeploymentArchiveImpl.BeanArchiveType.EXTERNAL);
                    WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered((BeanDeploymentArchive)bda);
                    for (Map.Entry moduleService : ServiceLoaders.loadModuleServices(moduleServicesProviders, (DeploymentUnit)deploymentUnit, (DeploymentUnit)deployment, (Module)module, null).entrySet()) {
                        bda.getServices().add((Class)moduleService.getKey(), (Service)Reflections.cast(moduleService.getValue()));
                    }
                    deploymentUnit.addToAttachmentList(WeldAttachments.ADDITIONAL_BEAN_DEPLOYMENT_MODULES, (Object)bda);
                    moduleBdas.add(bda);
                    existing.add(beansXmlUrl);
                }
                for (BeanDeploymentArchiveImpl i : moduleBdas) {
                    for (BeanDeploymentArchiveImpl j : moduleBdas) {
                        if (i == j) continue;
                        i.addBeanDeploymentArchive((BeanDeploymentArchive)j);
                    }
                }
            }
        }
    }

    private Map<String, List<String>> discover(BeanDiscoveryMode beanDiscoveryMode, URL beansXmlUrl, URL indexUrl, Set<AnnotationType> beanDefiningAnnotations) {
        BiConsumer<String, UrlScanner.ClassFile> consumer;
        ArrayList discoveredBeanClasses = new ArrayList();
        ArrayList allKnownClasses = new ArrayList();
        if (BeanDiscoveryMode.ANNOTATED.equals((Object)beanDiscoveryMode)) {
            Index index = this.tryLoadIndex(indexUrl);
            if (index != null) {
                consumer = (name, classFile) -> {
                    ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)name));
                    allKnownClasses.add(name);
                    if (classInfo != null && this.hasBeanDefiningAnnotation(classInfo, beanDefiningAnnotations)) {
                        discoveredBeanClasses.add(name);
                    }
                };
            } else {
                Indexer indexer = new Indexer();
                consumer = (name, classFile) -> {
                    try (InputStream in = classFile.openStream();){
                        ClassInfo classInfo = indexer.index(in);
                        allKnownClasses.add(name);
                        if (classInfo != null && this.hasBeanDefiningAnnotation(classInfo, beanDefiningAnnotations)) {
                            discoveredBeanClasses.add(name);
                        }
                    }
                    catch (IOException e) {
                        WeldLogger.DEPLOYMENT_LOGGER.cannotIndexClassName(name, (Object)beansXmlUrl);
                    }
                };
            }
        } else {
            consumer = (name, classFile) -> {
                allKnownClasses.add(name);
                discoveredBeanClasses.add(name);
            };
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("ALL_KNOWN_CLASSES", allKnownClasses);
        result.put("BEAN_CLASSES", discoveredBeanClasses);
        UrlScanner scanner = new UrlScanner(beansXmlUrl, consumer);
        return scanner.scan() ? result : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Index tryLoadIndex(URL indexUrl) {
        if (indexUrl == null) {
            return null;
        }
        try (InputStream in = indexUrl.openStream();){
            Index index = new IndexReader(in).read();
            return index;
        }
        catch (Exception e) {
            WeldLogger.DEPLOYMENT_LOGGER.cannotLoadAnnotationIndexOfExternalBeanArchive((Object)indexUrl);
            return null;
        }
    }

    private Map<URL, URL> findExportedResources(Module dependencyModule) {
        Set<URL> beanXmls = this.findExportedResource(dependencyModule, META_INF_BEANS_XML);
        if (beanXmls.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<URL> indexes = this.findExportedResource(dependencyModule, META_INF_JANDEX_IDX);
        HashMap<URL, URL> ret = new HashMap<URL, URL>();
        for (URL beansXml : beanXmls) {
            String urlBase = beansXml.toString().substring(0, beansXml.toString().length() - META_INF_BEANS_XML.length());
            URL idx = null;
            for (URL index : indexes) {
                if (!index.toString().startsWith(urlBase)) continue;
                idx = index;
                break;
            }
            ret.put(beansXml, idx);
        }
        return ret;
    }

    private Set<URL> findExportedResource(Module dependencyModule, String name) {
        Enumeration exported = dependencyModule.getExportedResources(name);
        return new HashSet<URL>(Collections.list(exported));
    }

    private boolean hasBeanDefiningAnnotation(ClassInfo classInfo, Set<AnnotationType> beanDefiningAnnotations) {
        Map annotationsMap = classInfo.annotations();
        for (AnnotationType beanDefiningAnnotation : beanDefiningAnnotations) {
            List annotations = (List)annotationsMap.get(beanDefiningAnnotation.getName());
            if (annotations == null) continue;
            for (AnnotationInstance annotationInstance : annotations) {
                if (!annotationInstance.target().equals(classInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private Module loadModuleDependency(DependencySpec dep) {
        ModuleDependencySpec dependency;
        ModuleLoader loader;
        if (dep instanceof ModuleDependencySpec && (loader = (dependency = (ModuleDependencySpec)dep).getModuleLoader()) != null) {
            try {
                return dependency.getModuleLoader().loadModule(dependency.getIdentifier());
            }
            catch (ModuleLoadException e) {
                return null;
            }
        }
        return null;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private BeansXml parseBeansXml(URL beansXmlFile, BeansXmlParser parser, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return parser.parse(beansXmlFile);
    }
}

