/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractConfigSource;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

    EnvConfigSource() {
        super("EnvConfigSource", 300);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(System::getenv));
    }

    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        Map<String, String> properties = this.getProperties();
        String value = properties.get(name);
        if (value != null) {
            return value;
        }
        String sanitizedName = PATTERN.matcher(name).replaceAll("_");
        value = properties.get(sanitizedName);
        if (value != null) {
            return value;
        }
        return properties.get(sanitizedName.toUpperCase());
    }
}

