/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import io.smallrye.faulttolerance.DefaultHystrixConcurrencyStrategy;
import java.lang.annotation.Annotation;
import javax.annotation.Resource;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.wildfly.extension.microprofile.faulttolerance.cdi.RequestContextCommandListener;
import org.wildfly.extension.microprofile.faulttolerance.cdi.WeldCommandListenersProvider;

public class MicroProfileFaultToleranceCDIExtension
implements Extension {
    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addAnnotatedType(beanManager.createAnnotatedType(RequestContextCommandListener.class), RequestContextCommandListener.class.getName());
        event.addAnnotatedType(beanManager.createAnnotatedType(WeldCommandListenersProvider.class), WeldCommandListenersProvider.class.getName());
    }

    void processAnnotatedType(@Observes ProcessAnnotatedType<DefaultHystrixConcurrencyStrategy> event) {
        event.configureAnnotatedType().filterFields(field -> "managedThreadFactory".equals(field.getJavaMember().getName())).forEach(field -> {
            field.remove(annotation -> Resource.class.equals(annotation.annotationType()));
            field.add((Annotation)((Object)ResourceLiteral.lookup("java:jboss/ee/concurrency/factory/default")));
        });
    }

    private static class ResourceLiteral
    extends AnnotationLiteral<Resource>
    implements Resource {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String lookup;
        private final Class<?> type;
        private final Resource.AuthenticationType authenticationType;
        private final boolean shareable;
        private final String mappedName;
        private final String description;

        static ResourceLiteral lookup(String lookup) {
            return new ResourceLiteral(null, lookup, null, null, null, null, null);
        }

        private ResourceLiteral(String name, String lookup, Class<?> type, Resource.AuthenticationType authenticationType, Boolean shareable, String mappedName, String description) {
            this.name = name == null ? "" : name;
            this.lookup = lookup == null ? "" : lookup;
            this.type = type == null ? Object.class : type;
            this.authenticationType = authenticationType == null ? Resource.AuthenticationType.CONTAINER : authenticationType;
            this.shareable = shareable == null || shareable != false;
            this.mappedName = mappedName == null ? "" : mappedName;
            this.description = description == null ? "" : description;
        }

        public String name() {
            return this.name;
        }

        public String lookup() {
            return this.lookup;
        }

        public Class<?> type() {
            return this.type;
        }

        public Resource.AuthenticationType authenticationType() {
            return this.authenticationType;
        }

        public boolean shareable() {
            return this.shareable;
        }

        public String mappedName() {
            return this.mappedName;
        }

        public String description() {
            return this.description;
        }
    }
}

